/*
 * Decompiled with CFR 0.152.
 */
package com.github.lowzj.retry;

import com.github.lowzj.retry.Preconditions;
import com.github.lowzj.retry.StopStrategy;
import com.github.lowzj.retry.attempt.Attempt;
import java.util.concurrent.TimeUnit;

public final class StopStrategies {
    private static final StopStrategy NEVER_STOP = new NeverStopStrategy();

    private StopStrategies() {
    }

    public static StopStrategy neverStop() {
        return NEVER_STOP;
    }

    public static StopStrategy stopAfterAttempt(int attemptNumber) {
        return new StopAfterAttemptStrategy(attemptNumber);
    }

    public static StopStrategy stopAfterDelay(long duration, TimeUnit timeUnit) {
        Preconditions.checkNotNull(timeUnit, "The time unit may not be null");
        return new StopAfterDelayStrategy(timeUnit.toMillis(duration));
    }

    private static final class StopAfterDelayStrategy
    implements StopStrategy {
        private final long maxDelay;

        StopAfterDelayStrategy(long maxDelay) {
            Preconditions.checkArgument(maxDelay >= 0L, "maxDelay must be >= 0 but is %d", maxDelay);
            this.maxDelay = maxDelay;
        }

        @Override
        public boolean shouldStop(Attempt failedAttempt) {
            return failedAttempt.getDelaySinceFirstAttempt() >= this.maxDelay;
        }
    }

    private static final class StopAfterAttemptStrategy
    implements StopStrategy {
        private final int maxAttemptNumber;

        StopAfterAttemptStrategy(int maxAttemptNumber) {
            Preconditions.checkArgument(maxAttemptNumber >= 1, "maxAttemptNumber must be >= 1 but is %d", maxAttemptNumber);
            this.maxAttemptNumber = maxAttemptNumber;
        }

        @Override
        public boolean shouldStop(Attempt failedAttempt) {
            return failedAttempt.getAttemptNumber() >= (long)this.maxAttemptNumber;
        }
    }

    private static final class NeverStopStrategy
    implements StopStrategy {
        private NeverStopStrategy() {
        }

        @Override
        public boolean shouldStop(Attempt failedAttempt) {
            return false;
        }
    }
}

