/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.gcc;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.compiler.CaptureStreamHandler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.gcc.AbstractLdLinker;
import com.github.maven_nar.cpptasks.gcc.GccLibrarian;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import java.io.File;
import java.util.Vector;

public class GppLinker
extends AbstractLdLinker {
    public static final String GPP_COMMAND = "g++";
    protected static final String[] discardFiles = new String[0];
    protected static final String[] objFiles = new String[]{".o", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final String libPrefix = "libraries: =";
    protected static final String[] libtoolObjFiles = new String[]{".fo", ".a", ".lib", ".dll", ".so", ".sl"};
    private static String[] linkerOptions = new String[]{"-bundle", "-dylib", "-dynamic", "-dynamiclib", "-nostartfiles", "-nostdlib", "-prebind", "-s", "-static", "-shared", "-symbolic", "-Xlinker", "-static-libgcc", "-shared-libgcc"};
    private static final GppLinker soLinker = new GppLinker("g++", objFiles, discardFiles, "lib", ".so", false, new GppLinker("g++", objFiles, discardFiles, "lib", ".so", true, null));
    private static final GppLinker instance = new GppLinker("g++", objFiles, discardFiles, "", "", false, null);
    private static final GppLinker machDllLinker = new GppLinker("g++", objFiles, discardFiles, "lib", ".dylib", false, null);
    private static final GppLinker machPluginLinker = new GppLinker("g++", objFiles, discardFiles, "lib", ".bundle", false, null);
    private static final GppLinker machJNILinker = new GppLinker("g++", objFiles, discardFiles, "lib", ".jnilib", false, null);
    private static final GppLinker dllLinker = new GppLinker("g++", objFiles, discardFiles, "", ".dll", false, null);
    private File[] libDirs;
    private String runtimeLibrary;
    private String gccLibrary;
    private String gfortranLibrary;
    private String gfortranMainLibrary;

    public static GppLinker getInstance() {
        return instance;
    }

    protected GppLinker(String command, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix, boolean isLibtool, GppLinker libtoolLinker) {
        super(command, "-dumpversion", extensions, ignoredExtensions, outputPrefix, outputSuffix, isLibtool, libtoolLinker);
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        String[] cmdout;
        String[] cmdin;
        super.addImpliedArgs(debug, linkType, args);
        if (this.getIdentifier().indexOf("mingw") >= 0) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("-mconsole");
            }
            if (linkType.isSubsystemGUI()) {
                args.addElement("-mwindows");
            }
        }
        this.gfortranLibrary = null;
        if (linkType.linkFortran()) {
            if (linkType.isStaticRuntime()) {
                cmdin = new String[]{"gfortran", "-print-file-name=libgfortran.a"};
                cmdout = CaptureStreamHandler.run(cmdin);
                if (cmdout.length > 0 && cmdout[0].indexOf(47) >= 0) {
                    this.gfortranLibrary = cmdout[0];
                }
            } else {
                this.gfortranLibrary = "-lgfortran";
            }
        }
        this.gfortranMainLibrary = null;
        if (linkType.linkFortran() && linkType.isExecutable() && linkType.linkFortranMain() && !this.isDarwin()) {
            if (linkType.isStaticRuntime()) {
                cmdin = new String[]{"gfortran", "-print-file-name=libgfortranbegin.a"};
                cmdout = CaptureStreamHandler.run(cmdin);
                if (cmdout.length > 0 && cmdout[0].indexOf(47) >= 0) {
                    this.gfortranMainLibrary = cmdout[0];
                }
            } else {
                this.gfortranMainLibrary = "-lgfortranbegin";
            }
        }
        this.runtimeLibrary = null;
        if (linkType.linkCPP()) {
            if (linkType.isStaticRuntime()) {
                if (this.isDarwin()) {
                    this.runtimeLibrary = "-lstdc++-static";
                } else {
                    cmdin = new String[]{GPP_COMMAND, "-print-file-name=libstdc++.a"};
                    cmdout = CaptureStreamHandler.run(cmdin);
                    if (cmdout.length > 0 && cmdout[0].indexOf(47) >= 0) {
                        this.runtimeLibrary = cmdout[0];
                    }
                }
            } else {
                this.runtimeLibrary = "-lstdc++";
            }
        }
        this.gccLibrary = null;
        this.gccLibrary = linkType.isStaticRuntime() ? "-static-libgcc" : (linkType.linkCPP() ? "-fexceptions" : "-shared-libgcc");
    }

    public String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        String[] rs = super.addLibrarySets(task, libsets, preargs, midargs, endargs);
        if (this.gfortranLibrary != null) {
            endargs.addElement(this.gfortranLibrary);
        }
        if (this.gfortranMainLibrary != null) {
            endargs.addElement(this.gfortranMainLibrary);
        }
        if (this.gccLibrary != null) {
            endargs.addElement(this.gccLibrary);
        }
        if (this.runtimeLibrary != null) {
            endargs.addElement(this.runtimeLibrary);
        }
        return rs;
    }

    public String decorateLinkerOption(StringBuffer buf, String arg) {
        String decoratedArg = arg;
        if (arg.length() > 1 && arg.charAt(0) == '-') {
            switch (arg.charAt(1)) {
                case 'B': 
                case 'F': 
                case 'L': 
                case 'O': 
                case 'W': 
                case 'f': 
                case 'g': 
                case 'l': 
                case 'm': 
                case 'u': {
                    break;
                }
                default: {
                    boolean known = false;
                    for (int i = 0; i < linkerOptions.length; ++i) {
                        if (!linkerOptions[i].equals(arg)) continue;
                        known = true;
                        break;
                    }
                    if (known) break;
                    buf.setLength(0);
                    buf.append("-Wl,");
                    buf.append(arg);
                    decoratedArg = buf.toString();
                }
            }
        }
        return decoratedArg;
    }

    public File[] getLibraryPath() {
        if (this.libDirs == null) {
            Vector<String> dirs = new Vector<String>();
            String[] args = new String[]{GPP_COMMAND, "-print-search-dirs"};
            String[] cmdout = CaptureStreamHandler.run(args);
            for (int i = 0; i < cmdout.length; ++i) {
                int prefixIndex = cmdout[i].indexOf(libPrefix);
                if (prefixIndex < 0) continue;
                int s = prefixIndex + libPrefix.length();
                int t = cmdout[i].indexOf(59, s);
                while (t > 0) {
                    dirs.addElement(cmdout[i].substring(s, t));
                    s = t + 1;
                    t = cmdout[i].indexOf(59, s);
                }
                dirs.addElement(cmdout[i].substring(s));
                ++i;
                while (i < cmdout.length) {
                    dirs.addElement(cmdout[i]);
                    ++i;
                }
            }
            Object[] libpath = new String[dirs.size()];
            dirs.copyInto(libpath);
            int count = CUtil.checkDirectoryArray((String[])libpath);
            this.libDirs = new File[count];
            int index = 0;
            for (int i = 0; i < libpath.length; ++i) {
                if (libpath[i] == null) continue;
                this.libDirs[index++] = new File((String)libpath[i]);
            }
        }
        return this.libDirs;
    }

    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            return GccLibrarian.getInstance();
        }
        if (type.isJNIModule()) {
            return this.isDarwin() ? machJNILinker : (this.isWindows() ? dllLinker : soLinker);
        }
        if (type.isPluginModule()) {
            return this.isDarwin() ? machPluginLinker : (this.isWindows() ? dllLinker : soLinker);
        }
        if (type.isSharedLibrary()) {
            return this.isDarwin() ? machDllLinker : (this.isWindows() ? dllLinker : soLinker);
        }
        return instance;
    }
}

