/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.borland;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.TargetInfo;
import com.github.maven_nar.cpptasks.borland.BorlandCCompiler;
import com.github.maven_nar.cpptasks.borland.BorlandLinker;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.ProcessorConfiguration;
import com.github.maven_nar.cpptasks.gcc.GccCCompiler;
import com.github.maven_nar.cpptasks.ide.ProjectDef;
import com.github.maven_nar.cpptasks.ide.ProjectWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class CBuilderXProjectWriter
implements ProjectWriter {
    public void writeProject(File fileName, CCTask task, ProjectDef projectDef, List sources, Map targets, TargetInfo linkTarget) throws IOException, SAXException {
        String projectName = projectDef.getName();
        if (projectName == null) {
            projectName = fileName.getName();
        }
        String basePath = fileName.getAbsoluteFile().getParent();
        File projectFile = new File(fileName + ".cbx");
        if (!projectDef.getOverwrite() && projectFile.exists()) {
            throw new BuildException("Not allowed to overwrite project file " + projectFile.toString());
        }
        CommandLineCompilerConfiguration compilerConfig = this.getBaseCompilerConfiguration(targets);
        if (compilerConfig == null) {
            throw new BuildException("Unable to generate C++ BuilderX project when gcc or bcc is not used.");
        }
        FileOutputStream outStream = new FileOutputStream(projectFile);
        OutputFormat format = new OutputFormat("xml", "UTF-8", true);
        XMLSerializer serializer = new XMLSerializer((OutputStream)outStream, format);
        ContentHandler content = serializer.asContentHandler();
        content.startDocument();
        AttributesImpl emptyAttrs = new AttributesImpl();
        content.startElement(null, "project", "project", emptyAttrs);
        PropertyWriter propertyWriter = new PropertyWriter(content);
        propertyWriter.write("build.config", "active", "0");
        propertyWriter.write("build.config", "count", "0");
        propertyWriter.write("build.config", "excludedefaultforzero", "0");
        propertyWriter.write("build.config.0", "builddir", "Debug");
        propertyWriter.write("build.config.0", "key", "Debug_Build");
        propertyWriter.write("build.config.0", "linux.builddir", "linux/Debug_Build");
        propertyWriter.write("build.config.0", "settings.MinGW", "default;debug");
        propertyWriter.write("build.config.0", "settings.gnuc++", "default;debug");
        propertyWriter.write("build.config.0", "settings.intellinia32", "default;debug");
        propertyWriter.write("build.config.0", "settings.mswin32", "default;debug");
        propertyWriter.write("build.config.0", "type", "Toolset");
        propertyWriter.write("build.config.0", "win32.builddir", "windows/Debug_Build");
        propertyWriter.write("build.node", "name", projectDef.getName());
        String buildType = this.getBuildType(task);
        propertyWriter.write("build.node", "type", buildType);
        propertyWriter.write("build.platform", "active", this.getActivePlatform(task));
        propertyWriter.write("build.platform", "linux.Debug_Build.toolset", "gnuc++");
        propertyWriter.write("build.platform", "linux.Release_Build.toolset", "gnuc++");
        propertyWriter.write("build.platform", "linux.default", "gnuc++");
        propertyWriter.write("build.platform", "linux.gnuc++.enabled", "1");
        propertyWriter.write("build.platform", "linux.mswin32.enabled", "1");
        propertyWriter.write("build.platform", "linux.win32b.enabled", "1");
        propertyWriter.write("build.platform", "solaris.default", "gnuc++");
        propertyWriter.write("build.platform", "solaris.enabled", "1");
        String toolset = this.getWin32Toolset(compilerConfig);
        propertyWriter.write("build.platform", "win32.default", toolset);
        propertyWriter.write("build.platform", "win32." + toolset + ".enabled", "1");
        propertyWriter.write("cbproject", "version", "X.1.0");
        if ("dllproject".equals(buildType)) {
            propertyWriter.write("gnuc++.g++compile", "option.fpic_using_GOT.enabled", "1");
            propertyWriter.write("gnuc++.g++link", "option.shared.enabled", "1");
            propertyWriter.write("intellinia32.icc", "option.minus_Kpic.enabled", "1");
            propertyWriter.write("intellinia32.icclink", "option.minus_shared.enabled", "1");
        }
        this.writeCompileOptions(basePath, propertyWriter, compilerConfig);
        this.writeLinkOptions(basePath, propertyWriter, linkTarget);
        propertyWriter.write("linux.gnuc++.Debug_Build", "saved", "1");
        if ("dllproject".equals(buildType)) {
            propertyWriter.write("runtime", "ExcludeDefaultForZero", "1");
        } else if ("exeproject".equals(buildType)) {
            propertyWriter.write("runtime.0", "BuildTargetOnRun", "com.borland.cbuilder.build.CBProjectBuilder$ProjectBuildAction;make");
            propertyWriter.write("runtime.0", "ConfigurationName", projectDef.getName());
            propertyWriter.write("runtime.0", "RunnableType", "com.borland.cbuilder.runtime.ExecutableRunner");
        }
        AttributesImpl fileAttributes = new AttributesImpl();
        fileAttributes.addAttribute(null, "path", "path", "#PCDATA", "");
        AttributesImpl gccAttributes = null;
        if (!"g++".equals(compilerConfig.getCommand())) {
            gccAttributes = new AttributesImpl();
            gccAttributes.addAttribute(null, "category", "category", "#PCDATA", "build.basecmd");
            gccAttributes.addAttribute(null, "name", "name", "#PCDATA", "linux.gnuc++.Debug_Build.g++_key");
            gccAttributes.addAttribute(null, "value", "value", "#PCDATA", compilerConfig.getCommand());
        }
        Iterator targetIter = targets.values().iterator();
        while (targetIter.hasNext()) {
            TargetInfo info = (TargetInfo)targetIter.next();
            File[] targetsources = info.getSources();
            for (int i = 0; i < targetsources.length; ++i) {
                String relativePath = CUtil.getRelativePath(basePath, targetsources[i]);
                fileAttributes.setValue(0, relativePath);
                content.startElement(null, "file", "file", fileAttributes);
                if (gccAttributes != null) {
                    content.startElement(null, "property", "property", gccAttributes);
                    content.endElement(null, "property", "property");
                }
                content.endElement(null, "file", "file");
            }
        }
        content.endElement(null, "project", "project");
        content.endDocument();
    }

    private String getBuildType(CCTask task) {
        String outType = task.getOuttype();
        if ("executable".equals(outType)) {
            return "exeproject";
        }
        if ("static".equals(outType)) {
            return "libraryproject";
        }
        return "dllproject";
    }

    private String getActivePlatform(CCTask task) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (osName.indexOf("windows") >= 0) {
            return "win32";
        }
        return "linux";
    }

    private String getWin32Toolset(CommandLineCompilerConfiguration compilerConfig) {
        if (compilerConfig != null && compilerConfig.getCompiler() instanceof BorlandCCompiler) {
            return "win32b";
        }
        return "MinGW";
    }

    private CommandLineCompilerConfiguration getBaseCompilerConfiguration(Map targets) {
        CommandLineCompilerConfiguration compilerConfig = null;
        Iterator targetIter = targets.values().iterator();
        while (targetIter.hasNext()) {
            TargetInfo targetInfo = (TargetInfo)targetIter.next();
            ProcessorConfiguration config = targetInfo.getConfiguration();
            String identifier = config.getIdentifier();
            if (!(config instanceof CommandLineCompilerConfiguration) || !((compilerConfig = (CommandLineCompilerConfiguration)config).getCompiler() instanceof GccCCompiler) && !(compilerConfig.getCompiler() instanceof BorlandCCompiler)) continue;
            return compilerConfig;
        }
        return null;
    }

    private void writeCompileOptions(String baseDir, PropertyWriter writer, CommandLineCompilerConfiguration compilerConfig) throws SAXException {
        boolean isBcc = false;
        boolean isUnix = true;
        String compileID = "linux.Debug_Build.gnuc++.g++compile";
        if (compilerConfig.getCompiler() instanceof BorlandCCompiler) {
            compileID = "win32.Debug_Build.win32b.bcc32";
            isUnix = false;
            isBcc = true;
        }
        File[] includePath = compilerConfig.getIncludePath();
        int includeIndex = 1;
        if (isUnix) {
            writer.write(compileID, "option.I.arg." + includeIndex++, "/usr/include");
            writer.write(compileID, "option.I.arg." + includeIndex++, "/usr/include/g++-3");
        }
        for (int i = 0; i < includePath.length; ++i) {
            String relPath = CUtil.getRelativePath(baseDir, includePath[i]);
            writer.write(compileID, "option.I.arg." + includeIndex++, relPath);
        }
        if (includePath.length > 0) {
            writer.write(compileID, "option.I.enabled", "1");
        }
        String defineBase = "option.D_MACRO_VALUE";
        if (isBcc) {
            defineBase = "option.D";
        }
        String defineOption = defineBase + ".arg.";
        int defineIndex = 1;
        int undefineIndex = 1;
        String[] preArgs = compilerConfig.getPreArguments();
        for (int i = 0; i < preArgs.length; ++i) {
            if (preArgs[i].startsWith("-D")) {
                writer.write(compileID, defineOption + defineIndex++, preArgs[i].substring(2));
                continue;
            }
            if (preArgs[i].startsWith("-U")) {
                writer.write(compileID, "option.U.arg." + undefineIndex++, preArgs[i].substring(2));
                continue;
            }
            if (preArgs[i].startsWith("-I") || preArgs[i].startsWith("-o")) continue;
            writer.write(compileID, "option." + preArgs[i].substring(1) + ".enabled", "1");
        }
        if (defineIndex > 1) {
            writer.write(compileID, defineBase + ".enabled", "1");
        }
        if (undefineIndex > 1) {
            writer.write(compileID, "option.U.enabled", "1");
        }
    }

    private void writeLinkOptions(String baseDir, PropertyWriter writer, TargetInfo linkTarget) throws SAXException {
        ProcessorConfiguration config;
        if (linkTarget != null && (config = linkTarget.getConfiguration()) instanceof CommandLineLinkerConfiguration) {
            CommandLineLinkerConfiguration linkConfig = (CommandLineLinkerConfiguration)config;
            if (linkConfig.getLinker() instanceof BorlandLinker) {
                String linkID = "win32.Debug_Build.win32b.ilink32";
                this.writeIlinkArgs(writer, linkID, linkConfig.getPreArguments());
                this.writeIlinkArgs(writer, linkID, linkConfig.getEndArguments());
                writer.write(linkID, "param.libfiles.1", "cw32mt.lib");
                writer.write(linkID, "param.libfiles.2", "import32.lib");
                int libIndex = 3;
                String[] libNames = linkConfig.getLibraryNames();
                for (int i = 0; i < libNames.length; ++i) {
                    writer.write(linkID, "param.libfiles." + libIndex++, libNames[i]);
                }
                String startup = linkConfig.getStartupObject();
                if (startup != null) {
                    writer.write(linkID, "param.objfiles.1", startup);
                }
            } else {
                String linkID = "linux.Debug_Build.gnuc++.g++link";
                this.writeLdArgs(writer, linkID, linkConfig.getPreArguments());
                this.writeLdArgs(writer, linkID, linkConfig.getEndArguments());
            }
        }
    }

    private void writeLdArgs(PropertyWriter writer, String linkID, String[] preArgs) throws SAXException {
        int objnameIndex = 1;
        int libnameIndex = 1;
        int libpathIndex = 1;
        for (int i = 0; i < preArgs.length; ++i) {
            if (preArgs[i].startsWith("-o")) {
                writer.write(linkID, "option.o.arg." + objnameIndex++, preArgs[i].substring(2));
                continue;
            }
            if (preArgs[i].startsWith("-l")) {
                writer.write(linkID, "option.l.arg." + libnameIndex++, preArgs[i].substring(2));
                continue;
            }
            if (preArgs[i].startsWith("-L")) {
                writer.write(linkID, "option.L.arg." + libpathIndex++, preArgs[i].substring(2));
                continue;
            }
            writer.write(linkID, "option." + preArgs[i].substring(1) + ".enabled", "1");
        }
        if (objnameIndex > 1) {
            writer.write(linkID, "option.o.enabled", "1");
        }
        if (libnameIndex > 1) {
            writer.write(linkID, "option.l.enabled", "1");
        }
        if (libpathIndex > 1) {
            writer.write(linkID, "option.L.enabled", "1");
        }
    }

    private void writeIlinkArgs(PropertyWriter writer, String linkID, String[] args) throws SAXException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '/' && args[i].charAt(0) != '-') continue;
            int equalsPos = args[i].indexOf(61);
            if (equalsPos > 0) {
                String option = "option." + args[i].substring(0, equalsPos - 1);
                writer.write(linkID, option + ".enabled", "1");
                writer.write(linkID, option + ".value", args[i].substring(equalsPos + 1));
                continue;
            }
            writer.write(linkID, "option." + args[i].substring(1) + ".enabled", "1");
        }
    }

    private static class PropertyWriter {
        private ContentHandler content;
        private AttributesImpl propertyAttributes;

        public PropertyWriter(ContentHandler contentHandler) {
            this.content = contentHandler;
            this.propertyAttributes = new AttributesImpl();
            this.propertyAttributes.addAttribute(null, "category", "category", "#PCDATA", "");
            this.propertyAttributes.addAttribute(null, "name", "name", "#PCDATA", "");
            this.propertyAttributes.addAttribute(null, "value", "value", "#PCDATA", "");
        }

        public final void write(String category, String name, String value) throws SAXException {
            this.propertyAttributes.setValue(0, category);
            this.propertyAttributes.setValue(1, name);
            this.propertyAttributes.setValue(2, value);
            this.content.startElement(null, "property", "property", this.propertyAttributes);
            this.content.endElement(null, "property", "property");
        }
    }
}

