/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.devstudio;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.devstudio.DevStudioLinker;
import com.github.maven_nar.cpptasks.devstudio.DevStudioProcessor;
import com.github.maven_nar.cpptasks.parser.CParser;
import com.github.maven_nar.cpptasks.parser.Parser;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public final class DevStudioResourceCompiler
extends CommandLineCompiler {
    private static final DevStudioResourceCompiler instance = new DevStudioResourceCompiler(false, null);
    private String identifier;

    public static DevStudioResourceCompiler getInstance() {
        return instance;
    }

    private DevStudioResourceCompiler(boolean newEnvironment, Environment env) {
        super("rc", null, new String[]{".rc"}, new String[]{".h", ".hpp", ".inl"}, ".res", false, null, newEnvironment, env);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        if (debug) {
            args.addElement("/D_DEBUG");
        } else {
            args.addElement("/DNDEBUG");
        }
    }

    protected void addWarningSwitch(Vector args, int level) {
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new DevStudioResourceCompiler(newEnvironment, env);
        }
        return this;
    }

    protected Parser createParser(File source) {
        return new CParser();
    }

    protected int getArgumentCountPerInputFile() {
        return 2;
    }

    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        DevStudioProcessor.getDefineSwitch(buffer, define, value);
    }

    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ";");
    }

    protected String getIncludeDirSwitch(String includeDir) {
        return DevStudioProcessor.getIncludeDirSwitch(includeDir);
    }

    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (index == 0) {
            String outputFileName = this.getOutputFileNames(filename, null)[0];
            String fullOutputName = new File(outputDir, outputFileName).toString();
            return "/fo" + fullOutputName;
        }
        return filename;
    }

    public Linker getLinker(LinkType type) {
        return DevStudioLinker.getInstance().getLinker(type);
    }

    public int getMaximumCommandLength() {
        return 32000;
    }

    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        String arg1 = this.getInputFileArgument(outputDir, inputFile, 0);
        String arg2 = this.getInputFileArgument(outputDir, inputFile, 1);
        return arg1.length() + arg2.length() + 2;
    }

    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        DevStudioProcessor.getUndefineSwitch(buffer, define);
    }

    public String getIdentifier() {
        return "Microsoft (R) Windows (R) Resource Compiler";
    }
}

