/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPM_HANDLE;

public class CreateLoadedResponse
extends TpmStructure {
    public TPM_HANDLE handle;
    public TPM2B_PRIVATE outPrivate;
    public TPMT_PUBLIC outPublic;
    public byte[] name;

    public CreateLoadedResponse(TPM_HANDLE _handle, TPM2B_PRIVATE _outPrivate, TPMT_PUBLIC _outPublic, byte[] _name) {
        this.handle = _handle;
        this.outPrivate = _outPrivate;
        this.outPublic = _outPublic;
        this.name = _name;
    }

    public CreateLoadedResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.handle.toTpm(buf);
        this.outPrivate.toTpm(buf);
        buf.writeInt(this.outPublic != null ? this.outPublic.toTpm().length : 0, 2);
        this.outPublic.toTpm(buf);
        buf.writeInt(this.name != null ? this.name.length : 0, 2);
        buf.write(this.name);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.handle = TPM_HANDLE.fromTpm(buf);
        this.outPrivate = TPM2B_PRIVATE.fromTpm(buf);
        int _outPublicSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _outPublicSize));
        this.outPublic = TPMT_PUBLIC.fromTpm(buf);
        buf.structSize.pop();
        int _nameSize = buf.readInt(2);
        this.name = new byte[_nameSize];
        buf.readArrayOfInts(this.name, 1, _nameSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static CreateLoadedResponse fromTpm(byte[] x) {
        CreateLoadedResponse ret = new CreateLoadedResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static CreateLoadedResponse fromTpm(InByteBuf buf) {
        CreateLoadedResponse ret = new CreateLoadedResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_CreateLoaded_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "TPM2B_PRIVATE", "outPrivate", this.outPrivate);
        _p.add(d, "TPMT_PUBLIC", "outPublic", this.outPublic);
        _p.add(d, "byte", "name", this.name);
    }
}

