/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPML_ALG_PROPERTY;
import tss.tpm.TPML_CC;
import tss.tpm.TPML_CCA;
import tss.tpm.TPML_ECC_CURVE;
import tss.tpm.TPML_HANDLE;
import tss.tpm.TPML_PCR_SELECTION;
import tss.tpm.TPML_TAGGED_PCR_PROPERTY;
import tss.tpm.TPML_TAGGED_POLICY;
import tss.tpm.TPML_TAGGED_TPM_PROPERTY;
import tss.tpm.TPMU_CAPABILITIES;
import tss.tpm.TPM_CAP;

public class GetCapabilityResponse
extends TpmStructure {
    public byte moreData;
    public TPMU_CAPABILITIES capabilityData;

    public GetCapabilityResponse(byte _moreData, TPMU_CAPABILITIES _capabilityData) {
        this.moreData = _moreData;
        this.capabilityData = _capabilityData;
    }

    public GetCapabilityResponse() {
    }

    public int GetUnionSelector_capabilityData() {
        if (this.capabilityData instanceof TPML_ALG_PROPERTY) {
            return 0;
        }
        if (this.capabilityData instanceof TPML_HANDLE) {
            return 1;
        }
        if (this.capabilityData instanceof TPML_CCA) {
            return 2;
        }
        if (this.capabilityData instanceof TPML_CC) {
            return 3;
        }
        if (this.capabilityData instanceof TPML_CC) {
            return 4;
        }
        if (this.capabilityData instanceof TPML_PCR_SELECTION) {
            return 5;
        }
        if (this.capabilityData instanceof TPML_TAGGED_TPM_PROPERTY) {
            return 6;
        }
        if (this.capabilityData instanceof TPML_TAGGED_PCR_PROPERTY) {
            return 7;
        }
        if (this.capabilityData instanceof TPML_ECC_CURVE) {
            return 8;
        }
        if (this.capabilityData instanceof TPML_TAGGED_POLICY) {
            return 9;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.write(this.moreData);
        buf.writeInt(this.GetUnionSelector_capabilityData(), 4);
        this.capabilityData.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.moreData = (byte)buf.readInt(1);
        int _capabilityDataCapability = buf.readInt(4);
        this.capabilityData = null;
        if (_capabilityDataCapability == TPM_CAP.ALGS.toInt()) {
            this.capabilityData = new TPML_ALG_PROPERTY();
        } else if (_capabilityDataCapability == TPM_CAP.HANDLES.toInt()) {
            this.capabilityData = new TPML_HANDLE();
        } else if (_capabilityDataCapability == TPM_CAP.COMMANDS.toInt()) {
            this.capabilityData = new TPML_CCA();
        } else if (_capabilityDataCapability == TPM_CAP.PP_COMMANDS.toInt()) {
            this.capabilityData = new TPML_CC();
        } else if (_capabilityDataCapability == TPM_CAP.AUDIT_COMMANDS.toInt()) {
            this.capabilityData = new TPML_CC();
        } else if (_capabilityDataCapability == TPM_CAP.PCRS.toInt()) {
            this.capabilityData = new TPML_PCR_SELECTION();
        } else if (_capabilityDataCapability == TPM_CAP.TPM_PROPERTIES.toInt()) {
            this.capabilityData = new TPML_TAGGED_TPM_PROPERTY();
        } else if (_capabilityDataCapability == TPM_CAP.PCR_PROPERTIES.toInt()) {
            this.capabilityData = new TPML_TAGGED_PCR_PROPERTY();
        } else if (_capabilityDataCapability == TPM_CAP.ECC_CURVES.toInt()) {
            this.capabilityData = new TPML_ECC_CURVE();
        } else if (_capabilityDataCapability == TPM_CAP.AUTH_POLICIES.toInt()) {
            this.capabilityData = new TPML_TAGGED_POLICY();
        }
        if (this.capabilityData == null) {
            throw new RuntimeException("Unexpected type selector");
        }
        this.capabilityData.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static GetCapabilityResponse fromTpm(byte[] x) {
        GetCapabilityResponse ret = new GetCapabilityResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static GetCapabilityResponse fromTpm(InByteBuf buf) {
        GetCapabilityResponse ret = new GetCapabilityResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_GetCapability_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "BYTE", "moreData", this.moreData);
        _p.add(d, "TPMU_CAPABILITIES", "capabilityData", this.capabilityData);
    }
}

