/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NV_PUBLIC;

public class NV_ReadPublicResponse
extends TpmStructure {
    public TPMS_NV_PUBLIC nvPublic;
    public byte[] nvName;

    public NV_ReadPublicResponse(TPMS_NV_PUBLIC _nvPublic, byte[] _nvName) {
        this.nvPublic = _nvPublic;
        this.nvName = _nvName;
    }

    public NV_ReadPublicResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.nvPublic != null ? this.nvPublic.toTpm().length : 0, 2);
        this.nvPublic.toTpm(buf);
        buf.writeInt(this.nvName != null ? this.nvName.length : 0, 2);
        buf.write(this.nvName);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _nvPublicSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _nvPublicSize));
        this.nvPublic = TPMS_NV_PUBLIC.fromTpm(buf);
        buf.structSize.pop();
        int _nvNameSize = buf.readInt(2);
        this.nvName = new byte[_nvNameSize];
        buf.readArrayOfInts(this.nvName, 1, _nvNameSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static NV_ReadPublicResponse fromTpm(byte[] x) {
        NV_ReadPublicResponse ret = new NV_ReadPublicResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static NV_ReadPublicResponse fromTpm(InByteBuf buf) {
        NV_ReadPublicResponse ret = new NV_ReadPublicResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_NV_ReadPublic_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_NV_PUBLIC", "nvPublic", this.nvPublic);
        _p.add(d, "byte", "nvName", this.nvName);
    }
}

