/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_TK_AUTH;

public class PolicySignedResponse
extends TpmStructure {
    public byte[] timeout;
    public TPMT_TK_AUTH policyTicket;

    public PolicySignedResponse(byte[] _timeout, TPMT_TK_AUTH _policyTicket) {
        this.timeout = _timeout;
        this.policyTicket = _policyTicket;
    }

    public PolicySignedResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.timeout != null ? this.timeout.length : 0, 2);
        buf.write(this.timeout);
        this.policyTicket.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _timeoutSize = buf.readInt(2);
        this.timeout = new byte[_timeoutSize];
        buf.readArrayOfInts(this.timeout, 1, _timeoutSize);
        this.policyTicket = TPMT_TK_AUTH.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static PolicySignedResponse fromTpm(byte[] x) {
        PolicySignedResponse ret = new PolicySignedResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static PolicySignedResponse fromTpm(InByteBuf buf) {
        PolicySignedResponse ret = new PolicySignedResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicySigned_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "timeout", this.timeout);
        _p.add(d, "TPMT_TK_AUTH", "policyTicket", this.policyTicket);
    }
}

