/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_SESSION;

public class SessionOut
extends TpmStructure {
    public byte[] nonceTpm;
    public TPMA_SESSION attributes;
    public byte[] auth;

    public SessionOut(byte[] _nonceTpm, TPMA_SESSION _attributes, byte[] _auth) {
        this.nonceTpm = _nonceTpm;
        this.attributes = _attributes;
        this.auth = _auth;
    }

    public SessionOut() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.nonceTpm != null ? this.nonceTpm.length : 0, 2);
        buf.write(this.nonceTpm);
        this.attributes.toTpm(buf);
        buf.writeInt(this.auth != null ? this.auth.length : 0, 2);
        buf.write(this.auth);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _nonceTpmSize = buf.readInt(2);
        this.nonceTpm = new byte[_nonceTpmSize];
        buf.readArrayOfInts(this.nonceTpm, 1, _nonceTpmSize);
        int _attributes = buf.readInt(1);
        this.attributes = TPMA_SESSION.fromInt(_attributes);
        int _authSize = buf.readInt(2);
        this.auth = new byte[_authSize];
        buf.readArrayOfInts(this.auth, 1, _authSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static SessionOut fromTpm(byte[] x) {
        SessionOut ret = new SessionOut();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static SessionOut fromTpm(InByteBuf buf) {
        SessionOut ret = new SessionOut();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("SessionOut");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "nonceTpm", this.nonceTpm);
        _p.add(d, "TPMA_SESSION", "attributes", this.attributes);
        _p.add(d, "byte", "auth", this.auth);
    }
}

