/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NULL_SIGNATURE;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SIGNATURE_ECDAA;
import tss.tpm.TPMS_SIGNATURE_ECDSA;
import tss.tpm.TPMS_SIGNATURE_ECSCHNORR;
import tss.tpm.TPMS_SIGNATURE_RSAPSS;
import tss.tpm.TPMS_SIGNATURE_RSASSA;
import tss.tpm.TPMS_SIGNATURE_SM2;
import tss.tpm.TPMT_HA;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;

public class SignResponse
extends TpmStructure {
    public TPMU_SIGNATURE signature;

    public SignResponse(TPMU_SIGNATURE _signature) {
        this.signature = _signature;
    }

    public SignResponse() {
    }

    public int GetUnionSelector_signature() {
        if (this.signature instanceof TPMS_SIGNATURE_RSASSA) {
            return 20;
        }
        if (this.signature instanceof TPMS_SIGNATURE_RSAPSS) {
            return 22;
        }
        if (this.signature instanceof TPMS_SIGNATURE_ECDSA) {
            return 24;
        }
        if (this.signature instanceof TPMS_SIGNATURE_ECDAA) {
            return 26;
        }
        if (this.signature instanceof TPMS_SIGNATURE_SM2) {
            return 27;
        }
        if (this.signature instanceof TPMS_SIGNATURE_ECSCHNORR) {
            return 28;
        }
        if (this.signature instanceof TPMT_HA) {
            return 5;
        }
        if (this.signature instanceof TPMS_SCHEME_HASH) {
            return Short.MAX_VALUE;
        }
        if (this.signature instanceof TPMS_NULL_SIGNATURE) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.GetUnionSelector_signature(), 2);
        this.signature.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _signatureSigAlg = buf.readInt(2);
        this.signature = null;
        if (_signatureSigAlg == TPM_ALG_ID.RSASSA.toInt()) {
            this.signature = new TPMS_SIGNATURE_RSASSA();
        } else if (_signatureSigAlg == TPM_ALG_ID.RSAPSS.toInt()) {
            this.signature = new TPMS_SIGNATURE_RSAPSS();
        } else if (_signatureSigAlg == TPM_ALG_ID.ECDSA.toInt()) {
            this.signature = new TPMS_SIGNATURE_ECDSA();
        } else if (_signatureSigAlg == TPM_ALG_ID.ECDAA.toInt()) {
            this.signature = new TPMS_SIGNATURE_ECDAA();
        } else if (_signatureSigAlg == TPM_ALG_ID.ANY.toInt()) {
            this.signature = new TPMS_SCHEME_HASH();
        } else if (_signatureSigAlg == TPM_ALG_ID.NULL.toInt()) {
            this.signature = new TPMS_NULL_SIGNATURE();
        }
        if (this.signature == null) {
            throw new RuntimeException("Unexpected type selector");
        }
        this.signature.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static SignResponse fromTpm(byte[] x) {
        SignResponse ret = new SignResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static SignResponse fromTpm(InByteBuf buf) {
        SignResponse ret = new SignResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Sign_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMU_SIGNATURE", "signature", this.signature);
    }
}

