/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_HA;
import tss.tpm.TPM_HANDLE;

public class TPM2_PCR_Extend_REQUEST
extends TpmStructure {
    public TPM_HANDLE pcrHandle;
    public TPMT_HA[] digests;

    public TPM2_PCR_Extend_REQUEST(TPM_HANDLE _pcrHandle, TPMT_HA[] _digests) {
        this.pcrHandle = _pcrHandle;
        this.digests = _digests;
    }

    public TPM2_PCR_Extend_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.pcrHandle.toTpm(buf);
        buf.writeInt(this.digests != null ? this.digests.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.digests);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.pcrHandle = TPM_HANDLE.fromTpm(buf);
        int _digestsCount = buf.readInt(4);
        this.digests = new TPMT_HA[_digestsCount];
        for (int j = 0; j < _digestsCount; ++j) {
            this.digests[j] = new TPMT_HA();
        }
        buf.readArrayOfTpmObjects(this.digests, _digestsCount);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PCR_Extend_REQUEST fromTpm(byte[] x) {
        TPM2_PCR_Extend_REQUEST ret = new TPM2_PCR_Extend_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PCR_Extend_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PCR_Extend_REQUEST ret = new TPM2_PCR_Extend_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PCR_Extend_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "pcrHandle", this.pcrHandle);
        _p.add(d, "TpmHash", "digests", this.digests);
    }
}

