/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_DIGEST;

public class TPML_DIGEST
extends TpmStructure {
    public TPM2B_DIGEST[] digests;

    public TPML_DIGEST(TPM2B_DIGEST[] _digests) {
        this.digests = _digests;
    }

    public TPML_DIGEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.digests != null ? this.digests.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.digests);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _count = buf.readInt(4);
        this.digests = new TPM2B_DIGEST[_count];
        for (int j = 0; j < _count; ++j) {
            this.digests[j] = new TPM2B_DIGEST();
        }
        buf.readArrayOfTpmObjects(this.digests, _count);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPML_DIGEST fromTpm(byte[] x) {
        TPML_DIGEST ret = new TPML_DIGEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPML_DIGEST fromTpm(InByteBuf buf) {
        TPML_DIGEST ret = new TPML_DIGEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPML_DIGEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM2B_DIGEST", "digests", this.digests);
    }
}

