/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_HA;
import tss.tpm.TPM_HANDLE;

public class TPMS_TAGGED_POLICY
extends TpmStructure {
    public TPM_HANDLE handle;
    public TPMT_HA policyHash;

    public TPMS_TAGGED_POLICY(TPM_HANDLE _handle, TPMT_HA _policyHash) {
        this.handle = _handle;
        this.policyHash = _policyHash;
    }

    public TPMS_TAGGED_POLICY() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.handle.toTpm(buf);
        this.policyHash.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.handle = TPM_HANDLE.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_TAGGED_POLICY fromTpm(byte[] x) {
        TPMS_TAGGED_POLICY ret = new TPMS_TAGGED_POLICY();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_TAGGED_POLICY fromTpm(InByteBuf buf) {
        TPMS_TAGGED_POLICY ret = new TPMS_TAGGED_POLICY();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_TAGGED_POLICY");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "TpmHash", "policyHash", this.policyHash);
    }
}

