/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.Crypto;
import tss.Helpers;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;

public class TPMT_HA
extends TpmStructure {
    public TPM_ALG_ID hashAlg;
    public byte[] digest;

    public TPMT_HA(TPM_ALG_ID _hashAlg, byte[] _digest) {
        this.hashAlg = _hashAlg;
        this.digest = _digest;
    }

    public TPMT_HA() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.hashAlg.toTpm(buf);
        buf.write(this.digest);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.hashAlg = TPM_ALG_ID.fromTpm(buf);
        this.digest = new byte[Crypto.digestSize(this.hashAlg)];
        buf.readArrayOfInts(this.digest, 1, this.digest.length);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMT_HA fromTpm(byte[] x) {
        TPMT_HA ret = new TPMT_HA();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMT_HA fromTpm(InByteBuf buf) {
        TPMT_HA ret = new TPMT_HA();
        ret.initFromTpm(buf);
        return ret;
    }

    public static TPMT_HA fromHashOf(TPM_ALG_ID hashAlg, byte[] data) {
        return new TPMT_HA(hashAlg, Crypto.hash(hashAlg, data));
    }

    public static TPMT_HA fromHashOf(TPM_ALG_ID hashAlg, String s) {
        try {
            byte[] buf = s.getBytes("UTF8");
            return TPMT_HA.fromHashOf(hashAlg, buf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("unexpected error");
        }
    }

    public TPMT_HA extend(byte[] x) {
        byte[] t = Helpers.concatenate(this.digest, x);
        this.digest = Crypto.hash(this.hashAlg, t);
        return this;
    }

    public TPMT_HA event(byte[] x) {
        byte[] s = Crypto.hash(this.hashAlg, x);
        byte[] t = Helpers.concatenate(this.digest, s);
        this.digest = Crypto.hash(this.hashAlg, t);
        return this;
    }

    public void reset() {
        this.digest = new byte[Crypto.digestSize(this.hashAlg)];
    }

    public static TPMT_HA zeroHash(TPM_ALG_ID alg) {
        return new TPMT_HA(alg, new byte[Crypto.digestSize(alg)]);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_HA");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "hashAlg", this.hashAlg);
        _p.add(d, "byte", "digest", this.digest);
    }
}

