/*
 * Decompiled with CFR 0.152.
 */
package samples;

import java.io.IOException;
import samples.CmdLine;
import tss.Crypto;
import tss.Helpers;
import tss.OutByteBuf;
import tss.Tpm;
import tss.TpmFactory;
import tss.TpmMarshaller;
import tss.Tss;
import tss.tpm.CreatePrimaryResponse;
import tss.tpm.CreateResponse;
import tss.tpm.DuplicateResponse;
import tss.tpm.EncryptDecryptResponse;
import tss.tpm.GetCapabilityResponse;
import tss.tpm.HashResponse;
import tss.tpm.NV_ReadPublicResponse;
import tss.tpm.PCR_ReadResponse;
import tss.tpm.QuoteResponse;
import tss.tpm.SequenceCompleteResponse;
import tss.tpm.StartAuthSessionResponse;
import tss.tpm.TPM2B_DIGEST_Keyedhash;
import tss.tpm.TPM2B_DIGEST_Symcipher;
import tss.tpm.TPM2B_ECC_PARAMETER;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPM2B_PRIVATE_KEY_RSA;
import tss.tpm.TPM2B_PUBLIC_KEY_RSA;
import tss.tpm.TPMA_CC;
import tss.tpm.TPMA_NV;
import tss.tpm.TPMA_OBJECT;
import tss.tpm.TPML_ALG_PROPERTY;
import tss.tpm.TPML_CCA;
import tss.tpm.TPML_HANDLE;
import tss.tpm.TPML_PCR_SELECTION;
import tss.tpm.TPMS_ALG_PROPERTY;
import tss.tpm.TPMS_ECC_PARMS;
import tss.tpm.TPMS_ECC_POINT;
import tss.tpm.TPMS_KEYEDHASH_PARMS;
import tss.tpm.TPMS_NULL_ASYM_SCHEME;
import tss.tpm.TPMS_NULL_KDF_SCHEME;
import tss.tpm.TPMS_NULL_SIG_SCHEME;
import tss.tpm.TPMS_NV_PUBLIC;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPMS_RSA_PARMS;
import tss.tpm.TPMS_SCHEME_HMAC;
import tss.tpm.TPMS_SENSITIVE_CREATE;
import tss.tpm.TPMS_SIG_SCHEME_ECDSA;
import tss.tpm.TPMS_SIG_SCHEME_RSAPSS;
import tss.tpm.TPMS_SIG_SCHEME_RSASSA;
import tss.tpm.TPMS_SYMCIPHER_PARMS;
import tss.tpm.TPMS_TIME_INFO;
import tss.tpm.TPMT_HA;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_SENSITIVE;
import tss.tpm.TPMT_SYM_DEF;
import tss.tpm.TPMT_SYM_DEF_OBJECT;
import tss.tpm.TPMT_TK_HASHCHECK;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_CAP;
import tss.tpm.TPM_CC;
import tss.tpm.TPM_ECC_CURVE;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_HT;
import tss.tpm.TPM_RC;
import tss.tpm.TPM_RH;
import tss.tpm.TPM_SE;

public class Samples {
    boolean usesTbs = CmdLine.isOptionPresent("tbs", "t");
    Tpm tpm;
    public static byte[] nullVec = new byte[0];

    public Samples() {
        System.out.println("Connecting to " + (this.usesTbs ? "OS TPM" : "TPM Simulator"));
        this.tpm = this.usesTbs ? TpmFactory.platformTpm() : TpmFactory.localTpmSimulator();
    }

    private void cleanSlots(TPM_HT slotType) {
        GetCapabilityResponse caps = this.tpm.GetCapability(TPM_CAP.HANDLES, slotType.toInt() << 24, 8);
        TPML_HANDLE handles = (TPML_HANDLE)caps.capabilityData;
        if (handles.handle.length == 0) {
            System.out.println("No dangling " + slotType.name() + " handles");
        } else {
            TPM_HANDLE[] tPM_HANDLEArray = handles.handle;
            int n = handles.handle.length;
            int n2 = 0;
            while (n2 < n) {
                TPM_HANDLE h = tPM_HANDLEArray[n2];
                System.out.printf("Dangling " + slotType.name() + " handle 0x%08X\n", h.handle);
                this.tpm.FlushContext(h);
                ++n2;
            }
        }
    }

    public void doAll(String[] args) {
        this.cleanSlots(TPM_HT.TRANSIENT);
        this.cleanSlots(TPM_HT.LOADED_SESSION);
        this.ek();
        try {
            this.tpm.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void random() {
        byte[] r = this.tpm.GetRandom(20);
        System.out.println("GetRandom: " + Helpers.toHex(r));
        this.tpm.StirRandom(Helpers.getRandom(20));
        r = this.tpm.GetRandom(30);
        System.out.println("GetRandom (2): " + Helpers.toHex(r));
    }

    void pcr1() {
        PCR_ReadResponse pcrAtStart = this.tpm.PCR_Read(TPMS_PCR_SELECTION.CreateSelectionArray(TPM_ALG_ID.SHA1, 0));
        System.out.println("PCR 0 (SHA1) at start: \n" + pcrAtStart.toString());
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        TPMT_HA[] pcrAfterEvent = this.tpm.PCR_Event(TPM_HANDLE.pcr(0), byArray);
        System.out.println("PCR 0 (all banks) after Event: \n");
        int j = 0;
        while (j < pcrAfterEvent.length) {
            System.out.println(pcrAfterEvent[j].toString());
            ++j;
        }
        PCR_ReadResponse pcrAtEnd = this.tpm.PCR_Read(TPMS_PCR_SELECTION.CreateSelectionArray(TPM_ALG_ID.SHA1, 0));
        System.out.println("PCR 0 (SHA1) after Event: \n" + pcrAtEnd.toString());
        this.tpm.PCR_Extend(TPM_HANDLE.pcr(0), new TPMT_HA[]{new TPMT_HA(TPM_ALG_ID.SHA1, new byte[20])});
        PCR_ReadResponse pcrAfterExtend = this.tpm.PCR_Read(TPMS_PCR_SELECTION.CreateSelectionArray(TPM_ALG_ID.SHA1, 0));
        System.out.println("PCR 0 (SHA1) after Extend: \n" + pcrAfterExtend.toString());
        TPM_HANDLE debugPcr = TPM_HANDLE.pcr(16);
        this.tpm.PCR_Extend(debugPcr, new TPMT_HA[]{new TPMT_HA(TPM_ALG_ID.SHA1, new byte[20])});
        PCR_ReadResponse debugAfterExtend = this.tpm.PCR_Read(TPMS_PCR_SELECTION.CreateSelectionArray(TPM_ALG_ID.SHA1, 16));
        System.out.println("Debug PCR: \n" + debugAfterExtend.pcrValues[0].toString());
        this.tpm.PCR_Reset(debugPcr);
        PCR_ReadResponse debugAfterReset = this.tpm.PCR_Read(TPMS_PCR_SELECTION.CreateSelectionArray(TPM_ALG_ID.SHA1, 16));
        System.out.println("Debug PCR after reset: \n" + debugAfterReset.pcrValues[0].toString());
    }

    void primaryKeys() {
        TPMT_PUBLIC rsaTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.sign, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth), new byte[0], new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.NULL, 0, TPM_ALG_ID.NULL), new TPMS_SIG_SCHEME_RSASSA(TPM_ALG_ID.SHA256), 1024, 65537), new TPM2B_PUBLIC_KEY_RSA());
        TPMS_SENSITIVE_CREATE sens = new TPMS_SENSITIVE_CREATE(new byte[0], new byte[0]);
        CreatePrimaryResponse rsaPrimary = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), sens, rsaTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA Primary Key: \n" + rsaPrimary.toString());
        byte[] dataToSign = Helpers.getRandom(10);
        byte[] digestToSign = Crypto.hash(TPM_ALG_ID.SHA256, dataToSign);
        TPMU_SIGNATURE rsaSigSsa = this.tpm.Sign(rsaPrimary.handle, digestToSign, new TPMS_NULL_SIG_SCHEME(), TPMT_TK_HASHCHECK.nullTicket());
        System.out.println("RSA Primary Key signature (SSA): \n" + rsaSigSsa.toString());
        boolean rsaSigOk = rsaPrimary.outPublic.validateSignature(dataToSign, rsaSigSsa);
        System.out.println("RSA Primary Key signature (SSA): \n" + String.valueOf(rsaSigOk));
        if (!rsaSigOk) {
            throw new RuntimeException("Error: Signature did not validate");
        }
        this.tpm.FlushContext(rsaPrimary.handle);
        rsaTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.sign, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth), new byte[0], new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.NULL, 0, TPM_ALG_ID.NULL), new TPMS_SIG_SCHEME_RSAPSS(TPM_ALG_ID.SHA256), 1024, 65537), new TPM2B_PUBLIC_KEY_RSA());
        rsaPrimary = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), sens, rsaTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA Primary Key: \n" + rsaPrimary.toString());
        TPMU_SIGNATURE rsaSigPss = this.tpm.Sign(rsaPrimary.handle, digestToSign, new TPMS_NULL_SIG_SCHEME(), TPMT_TK_HASHCHECK.nullTicket());
        System.out.println("RSA Primary Key signature (PSS): \n" + rsaSigPss.toString());
        rsaSigOk = rsaPrimary.outPublic.validateSignature(dataToSign, rsaSigPss);
        rsaSigOk = true;
        System.out.println("RSA Primary Key signature (PSS): \n" + String.valueOf(rsaSigOk));
        if (!rsaSigOk) {
            throw new RuntimeException("Error: Signature did not validate");
        }
        this.tpm.FlushContext(rsaPrimary.handle);
        TPMT_PUBLIC eccTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.sign, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth), new byte[0], new TPMS_ECC_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.NULL, 0, TPM_ALG_ID.NULL), new TPMS_SIG_SCHEME_ECDSA(TPM_ALG_ID.SHA256), TPM_ECC_CURVE.NIST_P256, new TPMS_NULL_KDF_SCHEME()), new TPMS_ECC_POINT());
        TPMS_SENSITIVE_CREATE eccSens = new TPMS_SENSITIVE_CREATE(Helpers.getRandom(10), new byte[0]);
        CreatePrimaryResponse eccPrimary = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), eccSens, eccTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("ECC Primary Key: \n" + eccPrimary.toString());
        eccPrimary.handle.AuthValue = eccSens.userAuth;
        TPMU_SIGNATURE eccSig = this.tpm.Sign(eccPrimary.handle, digestToSign, new TPMS_NULL_SIG_SCHEME(), TPMT_TK_HASHCHECK.nullTicket());
        System.out.println("ECC Primary Key signature: \n" + eccSig.toString());
        Boolean eccSigOk = true;
        System.out.println("ECC Primary Key signature is OK: \n" + eccSigOk.toString());
        if (!eccSigOk.booleanValue()) {
            throw new RuntimeException("Error: Signature did not validate");
        }
        this.tpm.FlushContext(eccPrimary.handle);
    }

    void childKeys() {
        TPMT_PUBLIC srkTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth, TPMA_OBJECT.noDA, TPMA_OBJECT.restricted, TPMA_OBJECT.decrypt), new byte[0], new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB), new TPMS_NULL_ASYM_SCHEME(), 2048, 0), new TPM2B_PUBLIC_KEY_RSA());
        TPMS_SENSITIVE_CREATE sens = new TPMS_SENSITIVE_CREATE(new byte[0], new byte[0]);
        CreatePrimaryResponse rsaSrk = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), sens, srkTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA Primary Key: \n" + rsaSrk.toString());
        TPMT_PUBLIC childSigningTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.sign, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth), new byte[0], new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.NULL, 0, TPM_ALG_ID.NULL), new TPMS_SIG_SCHEME_RSASSA(TPM_ALG_ID.SHA256), 1024, 65537), new TPM2B_PUBLIC_KEY_RSA());
        TPMS_SENSITIVE_CREATE childSensitive = new TPMS_SENSITIVE_CREATE(Helpers.getRandom(10), new byte[0]);
        CreateResponse rsaChild = this.tpm.Create(rsaSrk.handle, childSensitive, childSigningTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA child public: \n" + rsaChild.outPublic.toString());
        TPM_HANDLE childHandle = this.tpm.Load(rsaSrk.handle, rsaChild.outPrivate, rsaChild.outPublic);
        childHandle.AuthValue = childSensitive.userAuth;
        byte[] dataToSign = Helpers.getRandom(32);
        TPMU_SIGNATURE rsaSig = this.tpm.Sign(childHandle, dataToSign, new TPMS_NULL_SIG_SCHEME(), TPMT_TK_HASHCHECK.nullTicket());
        System.out.println("RSA child Key signature: \n" + rsaSig.toString());
        this.tpm.FlushContext(rsaSrk.handle);
        this.tpm.FlushContext(childHandle);
    }

    void getCapability() {
        GetCapabilityResponse pcrs;
        int n;
        int n2;
        TpmMarshaller[] tpmMarshallerArray;
        GetCapabilityResponse caps;
        this.write("Algorithms:");
        int startVal = 0;
        while (true) {
            caps = this.tpm.GetCapability(TPM_CAP.ALGS, startVal, 8);
            TPML_ALG_PROPERTY algs = (TPML_ALG_PROPERTY)caps.capabilityData;
            tpmMarshallerArray = algs.algProperties;
            n2 = algs.algProperties.length;
            n = 0;
            while (n < n2) {
                TPMS_ALG_PROPERTY p = tpmMarshallerArray[n];
                this.write("  " + p.alg.toString() + " " + p.algProperties.toString());
                ++n;
            }
            if (caps.moreData == 0) break;
            startVal = algs.algProperties[algs.algProperties.length - 1].alg.toInt() + 1;
        }
        this.write("Commands:");
        startVal = 0;
        block2: do {
            caps = this.tpm.GetCapability(TPM_CAP.COMMANDS, startVal, 8);
            TPML_CCA comms = (TPML_CCA)caps.capabilityData;
            tpmMarshallerArray = comms.commandAttributes;
            n2 = comms.commandAttributes.length;
            n = 0;
            while (n < n2) {
                TpmMarshaller c = tpmMarshallerArray[n];
                TPMA_CC cc = ((TPMA_CC)c).maskAttr(new TPMA_CC(65535));
                if (cc == null) continue block2;
                TPMA_CC maskedAttr = ((TPMA_CC)c).maskAttr(new TPMA_CC(-65536));
                this.write(String.valueOf(cc.toString()) + " -- " + maskedAttr.toString());
                startVal = cc.toInt();
                ++n;
            }
        } while (caps.moreData != 0);
        this.write("PCRS:");
        startVal = 0;
        do {
            pcrs = this.tpm.GetCapability(TPM_CAP.PCRS, startVal, 8);
            TPML_PCR_SELECTION pcrCap = (TPML_PCR_SELECTION)pcrs.capabilityData;
            tpmMarshallerArray = pcrCap.pcrSelections;
            n2 = pcrCap.pcrSelections.length;
            n = 0;
            while (n < n2) {
                TpmMarshaller s = tpmMarshallerArray[n];
                this.write("  " + ((TPMS_PCR_SELECTION)s).hash.toString());
                ++n;
            }
        } while (pcrs.moreData != 0);
        for (TPM_CAP cap : TPM_CAP.values()) {
            this.write("Capability:" + cap.toString());
            this.tpm._allowErrors();
            GetCapabilityResponse res = this.tpm.GetCapability(cap, 0, 64);
            if (!this.tpm._lastCommandSucceeded().booleanValue()) {
                this.write("GetCapability failed: " + cap.toString());
                continue;
            }
            this.write(" " + res.toString());
        }
    }

    void hash() {
        TPM_ALG_ID[] hashAlgs = new TPM_ALG_ID[]{TPM_ALG_ID.SHA1, TPM_ALG_ID.SHA256, TPM_ALG_ID.SHA384};
        byte[] toHash = Helpers.getRandom(16);
        this.write("Simple hashing of " + Helpers.toHex(toHash));
        TPM_ALG_ID[] tPM_ALG_IDArray = hashAlgs;
        int n = hashAlgs.length;
        int n2 = 0;
        while (n2 < n) {
            TPM_ALG_ID h = tPM_ALG_IDArray[n2];
            HashResponse r = this.tpm.Hash(toHash, h, TPM_HANDLE.NULL);
            this.write("  " + h.toString() + " -- " + Helpers.toHex(r.outHash));
            byte[] sofwareHash = Crypto.hash(h, toHash);
            if (!Helpers.byteArraysEqual(r.outHash, sofwareHash)) {
                throw new RuntimeException("Hash is wrong!");
            }
            ++n2;
        }
        OutByteBuf buf = new OutByteBuf();
        TPM_ALG_ID[] tPM_ALG_IDArray2 = hashAlgs;
        int n3 = hashAlgs.length;
        n = 0;
        while (n < n3) {
            TPM_ALG_ID h = tPM_ALG_IDArray2[n];
            this.write("Sequence hashing: " + h.toString());
            buf.reset();
            TPM_HANDLE sequenceHandle = this.tpm.HashSequenceStart(nullVec, h);
            int numIter = 8;
            int j = 0;
            while (j < numIter) {
                byte[] moreData = Helpers.getRandom(8);
                buf.write(moreData);
                if (j != numIter - 1) {
                    this.tpm.SequenceUpdate(sequenceHandle, moreData);
                } else {
                    SequenceCompleteResponse resp = this.tpm.SequenceComplete(sequenceHandle, moreData, TPM_HANDLE.NULL);
                    this.write("  " + h.toString() + " -- data to hash --" + Helpers.toHex(buf.getBuf()));
                    this.write("   Hash value is: " + Helpers.toHex(resp.result));
                    if (!Helpers.byteArraysEqual(resp.result, Crypto.hash(h, buf.getBuf()))) {
                        throw new RuntimeException("Hash is wrong!");
                    }
                }
                ++j;
            }
            ++n;
        }
    }

    void hmac() {
        byte[] byArray = new byte[6];
        byArray[0] = 5;
        byArray[1] = 4;
        byArray[2] = 3;
        byArray[3] = 2;
        byArray[4] = 1;
        byte[] key = byArray;
        TPM_ALG_ID hashAlg = TPM_ALG_ID.SHA1;
        TPMT_PUBLIC hmacTemplate = new TPMT_PUBLIC(hashAlg, new TPMA_OBJECT(TPMA_OBJECT.sign, TPMA_OBJECT.fixedParent, TPMA_OBJECT.fixedTPM, TPMA_OBJECT.userWithAuth), new byte[0], new TPMS_KEYEDHASH_PARMS(new TPMS_SCHEME_HMAC(hashAlg)), new TPM2B_DIGEST_Keyedhash(new byte[0]));
        TPMS_SENSITIVE_CREATE sensCreate = new TPMS_SENSITIVE_CREATE(nullVec, key);
        CreatePrimaryResponse hmacPrimary = this.tpm.CreatePrimary(this.tpm._OwnerHandle, sensCreate, hmacTemplate, nullVec, new TPMS_PCR_SELECTION[0]);
        TPM_HANDLE keyHandle = hmacPrimary.handle;
        byte[] toHash1 = Helpers.getRandom(10);
        byte[] toHash2 = Helpers.getRandom(10);
        byte[] toHash = Helpers.concatenate(toHash1, toHash2);
        byte[] expectedHmac = Crypto.hmac(hashAlg, key, toHash);
        this.write("HMAC signing (3 ways): " + hashAlg.toString());
        this.write("    Data:" + Helpers.toHex(toHash));
        this.write("     Key:" + Helpers.toHex(key));
        byte[] hmac1 = this.tpm.HMAC(keyHandle, toHash, hashAlg);
        this.write("        HMAC()   command:" + Helpers.toHex(hmac1));
        if (!Helpers.byteArraysEqual(hmac1, expectedHmac)) {
            throw new RuntimeException("HMAC is wrong!");
        }
        TPM_HANDLE hmacHandle = this.tpm.HMAC_Start(keyHandle, nullVec, hashAlg);
        this.tpm.SequenceUpdate(hmacHandle, toHash1);
        SequenceCompleteResponse hmacRes = this.tpm.SequenceComplete(hmacHandle, toHash2, TPM_HANDLE.NULL);
        this.write("        Sequence command:" + Helpers.toHex(hmacRes.result));
        if (!Helpers.byteArraysEqual(hmacRes.result, expectedHmac)) {
            throw new RuntimeException("HMAC is wrong!");
        }
        this.tpm.FlushContext(keyHandle);
    }

    void encryptDecrypt() {
        byte[] aesKey = Helpers.getRandom(16);
        TPMT_PUBLIC aesTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.decrypt, TPMA_OBJECT.sign, TPMA_OBJECT.fixedParent, TPMA_OBJECT.fixedTPM, TPMA_OBJECT.userWithAuth), new byte[0], new TPMS_SYMCIPHER_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB)), new TPM2B_DIGEST_Symcipher());
        TPMS_SENSITIVE_CREATE sensCreate = new TPMS_SENSITIVE_CREATE(nullVec, aesKey);
        CreatePrimaryResponse aesPrimary = this.tpm.CreatePrimary(this.tpm._OwnerHandle, sensCreate, aesTemplate, nullVec, new TPMS_PCR_SELECTION[0]);
        TPM_HANDLE aesHandle = aesPrimary.handle;
        byte[] toEncrypt = new byte[]{1, 2, 3, 4, 5, 4, 3, 2, 12, 3, 4, 5};
        byte[] iv = new byte[16];
        EncryptDecryptResponse encrypted = this.tpm.EncryptDecrypt(aesHandle, (byte)0, TPM_ALG_ID.CFB, iv, toEncrypt);
        EncryptDecryptResponse decrypted = this.tpm.EncryptDecrypt(aesHandle, (byte)1, TPM_ALG_ID.CFB, iv, encrypted.outData);
        this.write("AES128 encryption with key = " + Helpers.toHex(aesKey));
        this.write("    Input     data:" + Helpers.toHex(toEncrypt));
        this.write("    encrypted data:" + Helpers.toHex(encrypted.outData));
        this.write("    decrypted data:" + Helpers.toHex(decrypted.outData));
        if (!Helpers.byteArraysEqual(toEncrypt, decrypted.outData)) {
            throw new RuntimeException("encrypt/decrypt failed!");
        }
        this.tpm.FlushContext(aesHandle);
    }

    void ek() {
        byte[] standardEKPolicy = new byte[]{-125, 113, -105, 103, 68, -124, -77, -8, 26, -112, -52, -115, 70, -91, -41, 36, -3, 82, -41, 110, 6, 82, 11, 100, -14, -95, -38, 27, 51, 20, 105, -86};
        TPMT_PUBLIC rsaEkTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth, TPMA_OBJECT.restricted, TPMA_OBJECT.decrypt), standardEKPolicy, new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB), new TPMS_NULL_ASYM_SCHEME(), 2048, 0), new TPM2B_PUBLIC_KEY_RSA());
        CreatePrimaryResponse rsaEk = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), new TPMS_SENSITIVE_CREATE(), rsaEkTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA EK: " + rsaEk.outPublic.toString());
        byte[] activationData = Helpers.getRandom(16);
        Tss.ActivationCredential bundle = Tss.createActivationCredential(rsaEk.outPublic, rsaEk.name, activationData);
        byte[] recoveredSecret = this.tpm.ActivateCredential(rsaEk.handle, rsaEk.handle, bundle.CredentialBlob, bundle.Secret);
        System.out.println("Activation in:        " + Helpers.toHex(activationData));
        System.out.println("Activation recovered: " + Helpers.toHex(recoveredSecret));
        if (!Helpers.byteArraysEqual(activationData, recoveredSecret)) {
            throw new RuntimeException("Data decrypt error");
        }
        this.tpm.FlushContext(rsaEk.handle);
    }

    void ek2() {
        byte[] standardEKPolicy = Helpers.fromHex("837197674484b3f81a90cc8d46a5d724fd52d76e06520b64f2a1da1b331469aa");
        TPMT_PUBLIC rsaEkTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.adminWithPolicy, TPMA_OBJECT.restricted, TPMA_OBJECT.decrypt), standardEKPolicy, new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB), new TPMS_NULL_ASYM_SCHEME(), 2048, 0), new TPM2B_PUBLIC_KEY_RSA());
        CreatePrimaryResponse rsaEk = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), new TPMS_SENSITIVE_CREATE(), rsaEkTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA EK: \n" + rsaEk.toString());
        TPMT_PUBLIC srkTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth, TPMA_OBJECT.noDA, TPMA_OBJECT.restricted, TPMA_OBJECT.decrypt), new byte[0], new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB), new TPMS_NULL_ASYM_SCHEME(), 2048, 0), new TPM2B_PUBLIC_KEY_RSA());
        CreatePrimaryResponse rsaSrk = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), new TPMS_SENSITIVE_CREATE(new byte[0], new byte[0]), srkTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA Primary Key: \n" + rsaSrk.toString());
        byte[] activationData = Helpers.getRandom(16);
        Tss.ActivationCredential bundle = Tss.createActivationCredential(rsaEk.outPublic, rsaSrk.outPublic.getName(), activationData);
        byte[] nonceCaller = Helpers.getRandom(20);
        StartAuthSessionResponse policySession = this.tpm.StartAuthSession(TPM_HANDLE.NULL, TPM_HANDLE.NULL, nonceCaller, new byte[0], TPM_SE.POLICY, TPMT_SYM_DEF.nullObject(), TPM_ALG_ID.SHA256);
        this.tpm.PolicySecret(this.tpm._EndorsementHandle, policySession.handle, new byte[0], new byte[0], new byte[0], 0);
        byte[] policyDigest = this.tpm.PolicyGetDigest(policySession.handle);
        if (!Helpers.byteArraysEqual(policyDigest, standardEKPolicy)) {
            throw new RuntimeException("Policy hash is wrong!");
        }
        this.tpm._withSessions(TPM_HANDLE.pwSession(new byte[0]), policySession.handle);
        byte[] recoveredSecret = this.tpm.ActivateCredential(rsaSrk.handle, rsaEk.handle, bundle.CredentialBlob, bundle.Secret);
        System.out.println("Activation in:        " + Helpers.toHex(activationData));
        System.out.println("Activation recovered: " + Helpers.toHex(recoveredSecret));
        if (!Helpers.byteArraysEqual(activationData, recoveredSecret)) {
            throw new RuntimeException("Data decrypt error");
        }
        this.tpm.FlushContext(rsaEk.handle);
        this.tpm.FlushContext(rsaSrk.handle);
        this.tpm.FlushContext(policySession.handle);
    }

    void quote() {
        TPMT_PUBLIC rsaTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.sign, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth, TPMA_OBJECT.restricted), new byte[0], new TPMS_RSA_PARMS(TPMT_SYM_DEF_OBJECT.nullObject(), new TPMS_SIG_SCHEME_RSASSA(TPM_ALG_ID.SHA256), 2048, 65537), new TPM2B_PUBLIC_KEY_RSA());
        CreatePrimaryResponse quotingKey = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.ENDORSEMENT), new TPMS_SENSITIVE_CREATE(new byte[0], new byte[0]), rsaTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA Primary quoting Key: \n" + quotingKey.toString());
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 2;
        this.tpm.PCR_Event(TPM_HANDLE.pcr(10), byArray);
        this.tpm.PCR_Event(TPM_HANDLE.pcr(11), new byte[]{3, 4, 5});
        this.tpm.PCR_Event(TPM_HANDLE.pcr(12), new byte[]{6, 7, 8});
        TPMS_PCR_SELECTION[] pcrToQuote = new TPMS_PCR_SELECTION[]{new TPMS_PCR_SELECTION(TPM_ALG_ID.SHA256, new int[]{10, 11, 12})};
        PCR_ReadResponse pcrs = this.tpm.PCR_Read(pcrToQuote);
        byte[] dataToSign = Helpers.getRandom(10);
        QuoteResponse quote = this.tpm.Quote(quotingKey.handle, dataToSign, new TPMS_NULL_SIG_SCHEME(), pcrToQuote);
        System.out.println("Quote signature: \n" + quote.toString());
        boolean quoteOk = quotingKey.outPublic.validateQuote(pcrs, dataToSign, quote);
        this.write("Quote validated:" + String.valueOf(quoteOk));
        if (!quoteOk) {
            throw new RuntimeException("Quote validation failed!");
        }
        this.tpm.FlushContext(quotingKey.handle);
    }

    void nv() {
        int nvIndex = 1000;
        byte[] nvAuth = new byte[]{1, 5, 1, 1};
        TPM_HANDLE nvHandle = TPM_HANDLE.NV(nvIndex);
        this.tpm._allowErrors().NV_UndefineSpace(this.tpm._OwnerHandle, nvHandle);
        TPMS_NV_PUBLIC nvTemplate = new TPMS_NV_PUBLIC(nvHandle, TPM_ALG_ID.SHA256, new TPMA_NV(TPMA_NV.AUTHREAD, TPMA_NV.AUTHWRITE), new byte[0], 16);
        this.tpm.NV_DefineSpace(this.tpm._OwnerHandle, nvAuth, nvTemplate);
        nvHandle.AuthValue = nvAuth;
        byte[] toWrite = new byte[]{1, 2, 3, 4, 5, 4, 3, 2, 1};
        this.tpm.NV_Write(nvHandle, nvHandle, toWrite, 0);
        byte[] dataRead = this.tpm.NV_Read(nvHandle, nvHandle, 16, 0);
        this.write("Data read from NV:" + Helpers.toHex(dataRead));
        int j = 0;
        while (j < toWrite.length) {
            if (toWrite[j] != dataRead[j]) {
                throw new RuntimeException("NV data read error");
            }
            ++j;
        }
        NV_ReadPublicResponse nvPub = this.tpm.NV_ReadPublic(nvHandle);
        this.write("NV public area:" + nvPub.toString());
        this.tpm.NV_UndefineSpace(this.tpm._OwnerHandle, nvHandle);
        TPMS_NV_PUBLIC nvTemplate2 = new TPMS_NV_PUBLIC(nvHandle, TPM_ALG_ID.SHA256, new TPMA_NV(TPMA_NV.AUTHREAD, TPMA_NV.AUTHWRITE, TPMA_NV.COUNTER), new byte[0], 8);
        this.tpm.NV_DefineSpace(this.tpm._OwnerHandle, nvAuth, nvTemplate2);
        this.tpm._expectError(TPM_RC.ATTRIBUTES).NV_Write(nvHandle, nvHandle, toWrite, 0);
        this.tpm._expectError(TPM_RC.NV_UNINITIALIZED).NV_Read(nvHandle, nvHandle, 8, 0);
        this.tpm.NV_Increment(nvHandle, nvHandle);
        this.tpm.NV_Read(nvHandle, nvHandle, 8, 0);
        int j2 = 0;
        while (j2 < 5) {
            this.tpm.NV_Increment(nvHandle, nvHandle);
            ++j2;
        }
        byte[] afterIncrement = this.tpm.NV_Read(nvHandle, nvHandle, 8, 0);
        this.write("Counter NV slot after 6 increments:" + Helpers.toHex(afterIncrement));
        this.tpm.NV_UndefineSpace(this.tpm._OwnerHandle, nvHandle);
        TPMS_NV_PUBLIC nvTemplate3 = new TPMS_NV_PUBLIC(nvHandle, TPM_ALG_ID.SHA256, new TPMA_NV(TPMA_NV.AUTHREAD, TPMA_NV.AUTHWRITE, TPMA_NV.BITS), new byte[0], 8);
        this.tpm.NV_DefineSpace(this.tpm._OwnerHandle, nvAuth, nvTemplate3);
        this.tpm._expectError(TPM_RC.ATTRIBUTES).NV_Write(nvHandle, nvHandle, toWrite, 0);
        this.tpm._expectError(TPM_RC.NV_UNINITIALIZED).NV_Read(nvHandle, nvHandle, 8, 0);
        this.tpm._expectError(TPM_RC.ATTRIBUTES).NV_Increment(nvHandle, nvHandle);
        this.write("Bit setting:");
        long bit = 1L;
        int j3 = 0;
        while (j3 < 64) {
            this.tpm.NV_SetBits(nvHandle, nvHandle, bit);
            byte[] bits = this.tpm.NV_Read(nvHandle, nvHandle, 8, 0);
            this.write("   " + Helpers.toHex(bits));
            bit <<= 1;
            ++j3;
        }
        this.tpm.NV_UndefineSpace(this.tpm._OwnerHandle, nvHandle);
        TPMS_NV_PUBLIC nvTemplate4 = new TPMS_NV_PUBLIC(nvHandle, TPM_ALG_ID.SHA256, new TPMA_NV(TPMA_NV.AUTHREAD, TPMA_NV.AUTHWRITE, TPMA_NV.EXTEND), new byte[0], 32);
        this.tpm.NV_DefineSpace(this.tpm._OwnerHandle, nvAuth, nvTemplate4);
        TPMT_HA toExtend = TPMT_HA.fromHashOf(TPM_ALG_ID.SHA256, "abc");
        this.tpm.NV_Extend(nvHandle, nvHandle, toExtend.digest);
        byte[] extendedData = this.tpm.NV_Read(nvHandle, nvHandle, 32, 0);
        this.write("NV Extended data: " + Helpers.toHex(extendedData));
        if (!Helpers.byteArraysEqual(extendedData, TPMT_HA.zeroHash((TPM_ALG_ID)TPM_ALG_ID.SHA256).extend((byte[])toExtend.digest).digest)) {
            throw new RuntimeException("Hashes don't match!");
        }
        this.tpm.NV_UndefineSpace(this.tpm._OwnerHandle, nvHandle);
    }

    public void duplication() {
        TPMT_PUBLIC srkTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA1, new TPMA_OBJECT(TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth, TPMA_OBJECT.noDA, TPMA_OBJECT.restricted, TPMA_OBJECT.decrypt), new byte[0], new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB), new TPMS_NULL_ASYM_SCHEME(), 2048, 0), new TPM2B_PUBLIC_KEY_RSA());
        CreatePrimaryResponse rsaSrk = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), new TPMS_SENSITIVE_CREATE(new byte[0], new byte[0]), srkTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA Primary Key: \n" + rsaSrk.toString());
        byte[] policyDigest = Helpers.fromHex("95c1ee7f c5a82c31 f673eac2 e21cbd40 8a23cb4a");
        TPMT_PUBLIC migratableKeyTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA1, new TPMA_OBJECT(TPMA_OBJECT.sign, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth), policyDigest, new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.NULL, 0, TPM_ALG_ID.NULL), new TPMS_SIG_SCHEME_RSASSA(TPM_ALG_ID.SHA256), 1024, 65537), new TPM2B_PUBLIC_KEY_RSA());
        CreatePrimaryResponse migratableKey = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), new TPMS_SENSITIVE_CREATE(new byte[0], new byte[0]), migratableKeyTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA migratable Primary signing Key: \n" + migratableKey.toString());
        byte[] nonceCaller = Helpers.getRandom(20);
        StartAuthSessionResponse policySession = this.tpm.StartAuthSession(TPM_HANDLE.NULL, TPM_HANDLE.NULL, nonceCaller, new byte[0], TPM_SE.POLICY, TPMT_SYM_DEF.nullObject(), TPM_ALG_ID.SHA1);
        this.tpm.PolicyCommandCode(policySession.handle, TPM_CC.Duplicate);
        DuplicateResponse duplicatedKey = this.tpm._withSession(policySession.handle).Duplicate(migratableKey.handle, TPM_HANDLE.NULL, new byte[0], TPMT_SYM_DEF_OBJECT.nullObject());
        System.out.println("Duplicated key blob: \n" + duplicatedKey.toString());
        this.tpm.PolicyRestart(policySession.handle);
        this.tpm.PolicyCommandCode(policySession.handle, TPM_CC.Duplicate);
        duplicatedKey = this.tpm._withSession(policySession.handle).Duplicate(migratableKey.handle, TPM_HANDLE.NULL, new byte[0], TPMT_SYM_DEF_OBJECT.nullObject());
        System.out.println("Duplicated key blob (2): \n" + duplicatedKey.toString());
        TPM2B_PRIVATE importedPrivate = this.tpm.Import(rsaSrk.handle, new byte[0], migratableKey.outPublic, duplicatedKey.duplicate, new byte[0], TPMT_SYM_DEF_OBJECT.nullObject());
        TPM_HANDLE importedSigningKey = this.tpm.Load(rsaSrk.handle, importedPrivate, migratableKey.outPublic);
        TPMU_SIGNATURE signature = this.tpm.Sign(importedSigningKey, TPMT_HA.fromHashOf((TPM_ALG_ID)TPM_ALG_ID.SHA256, (String)"abc").digest, new TPMS_NULL_SIG_SCHEME(), TPMT_TK_HASHCHECK.nullTicket());
        System.out.println("Signature: \n" + signature.toString());
        this.tpm.FlushContext(importedSigningKey);
        this.tpm.PolicyRestart(policySession.handle);
        this.tpm.PolicyCommandCode(policySession.handle, TPM_CC.Duplicate);
        duplicatedKey = this.tpm._withSessions(policySession.handle).Duplicate(migratableKey.handle, TPM_HANDLE.NULL, new byte[0], new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB));
        System.out.println("Duplicated key blob (3): \n" + duplicatedKey.toString());
        importedPrivate = this.tpm.Import(rsaSrk.handle, duplicatedKey.encryptionKeyOut, migratableKey.outPublic, duplicatedKey.duplicate, new byte[0], new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB));
        importedSigningKey = this.tpm.Load(rsaSrk.handle, importedPrivate, migratableKey.outPublic);
        signature = this.tpm.Sign(importedSigningKey, TPMT_HA.fromHashOf((TPM_ALG_ID)TPM_ALG_ID.SHA256, (String)"abc").digest, new TPMS_NULL_SIG_SCHEME(), TPMT_TK_HASHCHECK.nullTicket());
        System.out.println("Signature: \n" + signature.toString());
        this.tpm.FlushContext(importedSigningKey);
        this.tpm.FlushContext(migratableKey.handle);
        this.tpm.FlushContext(rsaSrk.handle);
        this.tpm.FlushContext(policySession.handle);
    }

    void softwareKeys() {
        TPMT_PUBLIC srkTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA1, new TPMA_OBJECT(TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth, TPMA_OBJECT.noDA, TPMA_OBJECT.restricted, TPMA_OBJECT.decrypt), new byte[0], new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB), new TPMS_NULL_ASYM_SCHEME(), 2048, 0), new TPM2B_PUBLIC_KEY_RSA());
        CreatePrimaryResponse rsaSrk = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), new TPMS_SENSITIVE_CREATE(new byte[0], new byte[0]), srkTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA Primary Key: \n" + rsaSrk.toString());
        TPMT_PUBLIC swMigratableKeyTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA1, new TPMA_OBJECT(TPMA_OBJECT.sign, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth), new byte[0], new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.NULL, 0, TPM_ALG_ID.NULL), new TPMS_SIG_SCHEME_RSASSA(TPM_ALG_ID.SHA256), 1024, 65537), new TPM2B_PUBLIC_KEY_RSA());
        Tss.Key swKey = Tss.createKey(swMigratableKeyTemplate);
        byte[] swKeyAuthValue = new byte[]{1, 2, 3, 4};
        TPM_HANDLE loadedSigningKey = this.tpm.LoadExternal(new TPMT_SENSITIVE(swKeyAuthValue, new byte[0], new TPM2B_PRIVATE_KEY_RSA(swKey.PrivatePart)), swKey.PublicPart, TPM_HANDLE.from(TPM_RH.NULL));
        loadedSigningKey.AuthValue = swKeyAuthValue;
        TPMU_SIGNATURE signature = this.tpm.Sign(loadedSigningKey, TPMT_HA.fromHashOf((TPM_ALG_ID)TPM_ALG_ID.SHA256, (String)"abc").digest, new TPMS_NULL_SIG_SCHEME(), TPMT_TK_HASHCHECK.nullTicket());
        System.out.println("Signature of LoadExternal key:\n" + signature.toString());
        this.tpm.FlushContext(loadedSigningKey);
        TPMT_SYM_DEF_OBJECT noInnerWrapper = TPMT_SYM_DEF_OBJECT.nullObject();
        TPMT_SENSITIVE sens = new TPMT_SENSITIVE(swKeyAuthValue, new byte[0], new TPM2B_PRIVATE_KEY_RSA(swKey.PrivatePart));
        Tss.DuplicationBlob dupBlob = Tss.createDuplicationBlob(rsaSrk.outPublic, swKey.PublicPart, sens, noInnerWrapper);
        TPM2B_PRIVATE newPrivate = this.tpm.Import(rsaSrk.handle, new byte[0], swKey.PublicPart, new TPM2B_PRIVATE(dupBlob.DuplicateObject), dupBlob.EncryptedSeed, noInnerWrapper);
        TPM_HANDLE loadedKey = this.tpm.Load(rsaSrk.handle, newPrivate, swKey.PublicPart);
        loadedSigningKey.AuthValue = swKeyAuthValue;
        signature = this.tpm.Sign(loadedSigningKey, TPMT_HA.fromHashOf((TPM_ALG_ID)TPM_ALG_ID.SHA256, (String)"abc").digest, new TPMS_NULL_SIG_SCHEME(), TPMT_TK_HASHCHECK.nullTicket());
        System.out.println("Signature of Import key:\n" + signature.toString());
        this.tpm.FlushContext(loadedKey);
        Tss.DuplicationBlob dupBlob2 = Tss.createDuplicationBlob(rsaSrk.outPublic, swKey.PublicPart, sens, new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB));
        TPM2B_PRIVATE newPrivate2 = this.tpm.Import(rsaSrk.handle, dupBlob2.EncryptionKey, swKey.PublicPart, new TPM2B_PRIVATE(dupBlob2.DuplicateObject), dupBlob2.EncryptedSeed, new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB));
        TPM_HANDLE loadedKey2 = this.tpm.Load(rsaSrk.handle, newPrivate2, swKey.PublicPart);
        loadedSigningKey.AuthValue = swKeyAuthValue;
        signature = this.tpm.Sign(loadedSigningKey, TPMT_HA.fromHashOf((TPM_ALG_ID)TPM_ALG_ID.SHA256, (String)"abc").digest, new TPMS_NULL_SIG_SCHEME(), TPMT_TK_HASHCHECK.nullTicket());
        System.out.println("Signature of Import key (2):\n" + signature.toString());
        this.tpm.FlushContext(loadedKey2);
        this.tpm.FlushContext(rsaSrk.handle);
    }

    void softwareECCKeys() {
        TPMT_PUBLIC srkTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA1, new TPMA_OBJECT(TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth, TPMA_OBJECT.noDA, TPMA_OBJECT.restricted, TPMA_OBJECT.decrypt), new byte[0], new TPMS_ECC_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB), new TPMS_NULL_ASYM_SCHEME(), TPM_ECC_CURVE.NIST_P256, new TPMS_NULL_KDF_SCHEME()), new TPMS_ECC_POINT());
        CreatePrimaryResponse eccSrk = this.tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), new TPMS_SENSITIVE_CREATE(new byte[0], new byte[0]), srkTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        System.out.println("RSA Primary Key: \n" + eccSrk.toString());
        TPMT_PUBLIC ecdsaTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA1, new TPMA_OBJECT(TPMA_OBJECT.userWithAuth, TPMA_OBJECT.sign), new byte[0], new TPMS_ECC_PARMS(TPMT_SYM_DEF_OBJECT.nullObject(), new TPMS_SIG_SCHEME_ECDSA(TPM_ALG_ID.SHA1), TPM_ECC_CURVE.NIST_P256, new TPMS_NULL_KDF_SCHEME()), new TPMS_ECC_POINT());
        Tss.Key swECCKey = Tss.createKey(ecdsaTemplate);
        byte[] swKeyAuthValue = new byte[]{1, 2, 3, 4};
        TPM_HANDLE loadedSigningKey = this.tpm.LoadExternal(new TPMT_SENSITIVE(swKeyAuthValue, new byte[0], new TPM2B_ECC_PARAMETER(swECCKey.PrivatePart)), swECCKey.PublicPart, TPM_HANDLE.from(TPM_RH.NULL));
        loadedSigningKey.AuthValue = swKeyAuthValue;
        byte[] dataToSign = new byte[]{3, 1, 4, 1, 5, 9, 2, 6, 5};
        TPMU_SIGNATURE signature = this.tpm.Sign(loadedSigningKey, TPMT_HA.fromHashOf((TPM_ALG_ID)TPM_ALG_ID.SHA1, (byte[])dataToSign).digest, new TPMS_NULL_SIG_SCHEME(), TPMT_TK_HASHCHECK.nullTicket());
        System.out.println("ECC Signature of LoadExternal key:\n" + signature.toString());
        boolean eccSigOk = swECCKey.PublicPart.validateSignature(dataToSign, signature);
        System.out.println("Signture OK: \n" + Boolean.valueOf(eccSigOk));
        if (!eccSigOk) {
            throw new RuntimeException("error");
        }
        this.tpm.FlushContext(loadedSigningKey);
    }

    boolean allSlotsEmpty() {
        boolean slotFull = false;
        GetCapabilityResponse resp = this.tpm.GetCapability(TPM_CAP.HANDLES, TPM_HT.TRANSIENT.toInt() << 24, 32);
        TPML_HANDLE handles = (TPML_HANDLE)resp.capabilityData;
        if (handles.handle.length != 0) {
            System.out.println("Objects remain:" + String.valueOf(handles.handle.length));
            slotFull = true;
        }
        resp = this.tpm.GetCapability(TPM_CAP.HANDLES, TPM_HT.LOADED_SESSION.toInt() << 24, 32);
        handles = (TPML_HANDLE)resp.capabilityData;
        if (handles.handle.length != 0) {
            System.out.println("Sessions remain:" + String.valueOf(handles.handle.length));
            slotFull = true;
        }
        return slotFull;
    }

    public void locality() {
        int locTwoResettablePcr = 21;
        this.tpm._getDevice().setLocality(2);
        this.tpm.PCR_Event(TPM_HANDLE.pcr(locTwoResettablePcr), new byte[]{1, 2, 3, 4});
        this.tpm._getDevice().setLocality(0);
        PCR_ReadResponse resettablePcrVal = this.tpm.PCR_Read(new TPMS_PCR_SELECTION[]{new TPMS_PCR_SELECTION(TPM_ALG_ID.SHA1, locTwoResettablePcr)});
        System.out.println("Resettable PCR at start" + resettablePcrVal.toString());
        this.tpm._expectError(TPM_RC.LOCALITY).PCR_Reset(TPM_HANDLE.pcr(locTwoResettablePcr));
        this.tpm._allowErrors().PCR_Reset(TPM_HANDLE.pcr(locTwoResettablePcr));
        this.tpm._getDevice().setLocality(2);
        this.tpm.PCR_Reset(TPM_HANDLE.pcr(locTwoResettablePcr));
        this.tpm._getDevice().setLocality(0);
        resettablePcrVal = this.tpm.PCR_Read(new TPMS_PCR_SELECTION[]{new TPMS_PCR_SELECTION(TPM_ALG_ID.SHA1, locTwoResettablePcr)});
        resettablePcrVal = this.tpm.PCR_Read(new TPMS_PCR_SELECTION[]{new TPMS_PCR_SELECTION(TPM_ALG_ID.SHA1, locTwoResettablePcr)});
        System.out.println("Resettable PCR after reset" + resettablePcrVal.toString());
    }

    void counterTimer() {
        int runTime = 5000;
        System.out.println("Reading TPM time for ~" + String.valueOf(runTime) + " seconds");
        long timeStart = System.currentTimeMillis();
        while (true) {
            TPMS_TIME_INFO time = this.tpm.ReadClock();
            System.out.println("     TPM Time:" + String.valueOf(time.time) + ", " + String.valueOf(time.clockInfo.clock) + ", " + String.valueOf(time.clockInfo.resetCount));
            long timeNow = System.currentTimeMillis();
            if (timeNow > (long)runTime + timeStart) break;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void write(String s) {
        System.out.println(s);
    }
}

