/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECCurve;
import tss.Helpers;
import tss.OutByteBuf;
import tss.TpmException;
import tss.tpm.PCR_ReadResponse;
import tss.tpm.QuoteResponse;
import tss.tpm.TPM2B_PUBLIC_KEY_RSA;
import tss.tpm.TPMS_ATTEST;
import tss.tpm.TPMS_ECC_PARMS;
import tss.tpm.TPMS_QUOTE_INFO;
import tss.tpm.TPMS_RSA_PARMS;
import tss.tpm.TPMS_SIGNATURE_RSAPSS;
import tss.tpm.TPMS_SIGNATURE_RSASSA;
import tss.tpm.TPMS_SIG_SCHEME_ECDSA;
import tss.tpm.TPMS_SIG_SCHEME_RSAPSS;
import tss.tpm.TPMS_SIG_SCHEME_RSASSA;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_ECC_CURVE;
import tss.tpm.TPM_GENERATED;

public class Crypto {
    public static int digestSize(TPM_ALG_ID alg) {
        switch (alg.asEnum()) {
            case SHA1: {
                return 20;
            }
            case SHA256: {
                return 32;
            }
            case SHA384: {
                return 48;
            }
            case SHA512: {
                return 64;
            }
        }
        throw new RuntimeException("Unknown algorithm ID (not a hash?)");
    }

    public static byte[] hash(TPM_ALG_ID alg, byte[] data) {
        Digest d = Crypto.getDigest(alg);
        byte[] res = new byte[d.getDigestSize()];
        d.update(data, 0, data.length);
        d.doFinal(res, 0);
        return res;
    }

    public static byte[] hmac(TPM_ALG_ID alg, byte[] key, byte[] data) {
        HMac h = new HMac(Crypto.getDigest(alg));
        byte[] result = new byte[h.getMacSize()];
        KeyParameter kp = new KeyParameter(key);
        h.init((CipherParameters)kp);
        h.update(data, 0, data.length);
        h.doFinal(result, 0);
        return result;
    }

    public static boolean validateSignature(TPMT_PUBLIC _pubKey, byte[] _dataThatWasSigned, TPMU_SIGNATURE _signature) {
        if (_pubKey.parameters instanceof TPMS_RSA_PARMS) {
            TPMS_RSA_PARMS rsaParms = (TPMS_RSA_PARMS)_pubKey.parameters;
            TPM2B_PUBLIC_KEY_RSA rsaPubKey = (TPM2B_PUBLIC_KEY_RSA)_pubKey.unique;
            int exponent = rsaParms.exponent;
            BigInteger exp = BigInteger.valueOf(exponent);
            BigInteger pub = new BigInteger(1, rsaPubKey.buffer);
            RSAKeyParameters pubKey = new RSAKeyParameters(false, pub, exp);
            if (rsaParms.scheme instanceof TPMS_SIG_SCHEME_RSAPSS) {
                TPMS_SIGNATURE_RSAPSS theRsaSig = (TPMS_SIGNATURE_RSAPSS)_signature;
                TPMS_SIG_SCHEME_RSAPSS scheme = (TPMS_SIG_SCHEME_RSAPSS)rsaParms.scheme;
                TPM_ALG_ID hashAlg = scheme.hashAlg;
                RSABlindedEngine rsaEngine = new RSABlindedEngine();
                rsaEngine.init(false, (CipherParameters)pubKey);
                RSADigestSigner signer = new RSADigestSigner(Crypto.getDigest(theRsaSig.hash));
                signer.init(false, (CipherParameters)pubKey);
                signer.update(_dataThatWasSigned, 0, _dataThatWasSigned.length);
                boolean sigOk = signer.verifySignature(theRsaSig.sig);
                return sigOk;
            }
            if (rsaParms.scheme instanceof TPMS_SIG_SCHEME_RSASSA) {
                TPMS_SIGNATURE_RSASSA theRsaSig = (TPMS_SIGNATURE_RSASSA)_signature;
                TPMS_SIG_SCHEME_RSASSA scheme = (TPMS_SIG_SCHEME_RSASSA)rsaParms.scheme;
                TPM_ALG_ID hashAlg = scheme.hashAlg;
                RSADigestSigner signer = new RSADigestSigner(Crypto.getDigest(hashAlg));
                signer.init(false, (CipherParameters)pubKey);
                signer.update(_dataThatWasSigned, 0, _dataThatWasSigned.length);
                Boolean sigOk = signer.verifySignature(theRsaSig.sig);
                return sigOk;
            }
        }
        if (_pubKey.parameters instanceof TPMS_ECC_PARMS) {
            TPMS_ECC_PARMS eccParms = (TPMS_ECC_PARMS)_pubKey.parameters;
            if (eccParms.scheme instanceof TPMS_SIG_SCHEME_ECDSA) {
                return true;
            }
            throw new RuntimeException("Not implemented");
        }
        throw new RuntimeException("Not implemented");
    }

    public static boolean validateQuote(TPMT_PUBLIC pubKey, PCR_ReadResponse expectedPcrs, byte[] nonce, QuoteResponse quote) {
        byte[] expectedPcrSelect;
        TPMS_ATTEST attest = quote.quoted;
        if (attest.magic != TPM_GENERATED.VALUE) {
            return false;
        }
        if (!Helpers.byteArraysEqual(attest.extraData, nonce)) {
            return false;
        }
        TPMS_QUOTE_INFO quoteInfo = (TPMS_QUOTE_INFO)attest.attested;
        if (quoteInfo.pcrSelect.length != expectedPcrs.pcrSelectionOut.length) {
            return false;
        }
        byte[] quoteSelect = OutByteBuf.arrayToByteBuf(quoteInfo.pcrSelect);
        if (!Helpers.byteArraysEqual(quoteSelect, expectedPcrSelect = OutByteBuf.arrayToByteBuf(expectedPcrs.pcrSelectionOut))) {
            return false;
        }
        OutByteBuf pcrBuf = new OutByteBuf();
        for (int j = 0; j < expectedPcrs.pcrValues.length; ++j) {
            pcrBuf.write(expectedPcrs.pcrValues[j].buffer);
        }
        TPM_ALG_ID hashAlg = Crypto.getSigningHashAlg(pubKey);
        byte[] pcrHash = Crypto.hash(hashAlg, pcrBuf.getBuf());
        if (!Helpers.byteArraysEqual(pcrHash, quoteInfo.pcrDigest)) {
            return false;
        }
        byte[] signedBlob = quote.quoted.toTpm();
        Boolean quoteOk = Crypto.validateSignature(pubKey, signedBlob, quote.signature);
        return quoteOk;
    }

    public static ECPublicKey decodeKey(byte[] encoded) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        X9ECParameters params = ECNamedCurveTable.getByName((String)"secp256k1");
        KeyFactory fact = KeyFactory.getInstance("ECDSA", "BC");
        ECCurve curve = params.getCurve();
        EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)curve, (byte[])params.getSeed());
        ECPoint point = ECPointUtil.decodePoint((EllipticCurve)ellipticCurve, (byte[])encoded);
        return null;
    }

    public static Digest getDigest(TPM_ALG_ID alg) {
        switch (alg.asEnum()) {
            case SHA1: {
                return new SHA1Digest();
            }
            case SHA256: {
                return new SHA256Digest();
            }
            case SHA384: {
                return new SHA384Digest();
            }
            case SHA512: {
                return new SHA512Digest();
            }
        }
        throw new RuntimeException("No such digest");
    }

    public static byte[] KDFa(TPM_ALG_ID hmacHash, byte[] hmacKey, String label, byte[] contextU, byte[] contextV, int numBitsRequired) {
        int bitsPerLoop = Crypto.digestSize(hmacHash) * 8;
        long numLoops = (numBitsRequired + bitsPerLoop - 1) / bitsPerLoop;
        byte[] kdfStream = new byte[(int)(numLoops * (long)bitsPerLoop / 8L)];
        int j = 0;
        while ((long)j < numLoops) {
            byte[] toHmac = Helpers.concatenate(new byte[][]{Helpers.hostToNet(j + 1), Crypto.stringToLabel(label), contextU, contextV, Helpers.hostToNet(numBitsRequired)});
            byte[] fragment = Crypto.hmac(hmacHash, hmacKey, toHmac);
            System.arraycopy(fragment, 0, kdfStream, j * bitsPerLoop / 8, fragment.length);
            ++j;
        }
        return Helpers.shiftRight(kdfStream, (int)((long)bitsPerLoop * numLoops - (long)numBitsRequired));
    }

    public static byte[] oaepEncrypt(TPMS_RSA_PARMS parms, TPM2B_PUBLIC_KEY_RSA key, byte[] data, TPM_ALG_ID hashAlg, String encodingLabel) {
        byte[] encodingParms = Crypto.stringToLabel(encodingLabel);
        int exponent = parms.exponent;
        if (exponent == 0) {
            exponent = 65537;
        }
        BigInteger exp = BigInteger.valueOf(exponent);
        BigInteger pub = new BigInteger(1, key.buffer);
        RSAKeyParameters pubKey = new RSAKeyParameters(false, pub, exp);
        try {
            OAEPEncoding cipher = new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine(), Crypto.getDigest(hashAlg), encodingParms);
            cipher.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)pubKey));
            byte[] outX = cipher.processBlock(data, 0, data.length);
            return outX;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Encoding failed");
        }
    }

    public static byte[] asymEncrypt(TPMT_PUBLIC _pub, byte[] data, String encodingParms) {
        return Crypto.oaepEncrypt((TPMS_RSA_PARMS)_pub.parameters, (TPM2B_PUBLIC_KEY_RSA)_pub.unique, data, _pub.nameAlg, encodingParms);
    }

    static byte[] stringToLabel(String s) {
        return Helpers.concatenate(Charset.forName("UTF-8").encode(s).array(), new byte[]{0});
    }

    public static TPM_ALG_ID getSigningHashAlg(TPMT_PUBLIC pub) {
        if (pub.parameters instanceof TPMS_RSA_PARMS) {
            TPMS_RSA_PARMS rsaParms = (TPMS_RSA_PARMS)pub.parameters;
            if (rsaParms.scheme instanceof TPMS_SIG_SCHEME_RSASSA) {
                return ((TPMS_SIG_SCHEME_RSASSA)rsaParms.scheme).hashAlg;
            }
            if (rsaParms.scheme instanceof TPMS_SIG_SCHEME_RSAPSS) {
                return ((TPMS_SIG_SCHEME_RSAPSS)rsaParms.scheme).hashAlg;
            }
            throw new RuntimeException("Unsupported scheme");
        }
        throw new RuntimeException("Unsupported algorithm");
    }

    public static byte[] cfbEncrypt(boolean _encrypt, TPM_ALG_ID _algId, byte[] _key, byte[] _iv, byte[] _x) {
        if (_algId != TPM_ALG_ID.AES) {
            throw new TpmException("Only AES is supported");
        }
        int symKeySize = _key.length * 8;
        byte[] iv = _iv == null ? new byte[]{} : _iv;
        CFBBlockCipher encryptCipher = new CFBBlockCipher((BlockCipher)new AESEngine(), symKeySize);
        KeyParameter key = new KeyParameter(_key);
        encryptCipher.init(_encrypt, (CipherParameters)new ParametersWithIV((CipherParameters)key, iv));
        byte[] encData = new byte[_x.length];
        int numEncrypted = encryptCipher.processBytes(_x, 0, _x.length, encData, 0);
        if (numEncrypted != _x.length) {
            throw new RuntimeException("Error!");
        }
        return encData;
    }

    public static RsaKeyPair createRsaKey(int keySize, int exponent) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(keySize);
            KeyPair key = keyGen.generateKeyPair();
            RSAPrivateCrtKey priv = (RSAPrivateCrtKey)key.getPrivate();
            RSAPublicKey pub = (RSAPublicKey)key.getPublic();
            RsaKeyPair newKey = new RsaKeyPair();
            newKey.PublicKey = pub.getModulus();
            newKey.PrivateKey = priv.getPrimeP();
            return newKey;
        }
        catch (Exception e) {
            throw new TpmException("Bad alg:", e);
        }
    }

    public static ECCKeyPair createECCKey(TPM_ECC_CURVE curveId, TPM_ALG_ID alg) {
        try {
            ECCKeyPair newKey = new ECCKeyPair();
            ECGenParameterSpec ecGenSpec = new ECGenParameterSpec(Crypto.ecTpmToBc(curveId));
            KeyPairGenerator g = KeyPairGenerator.getInstance(Crypto.ecTpmToBc(alg), "BC");
            g.initialize(ecGenSpec, new SecureRandom());
            KeyPair pairX = g.generateKeyPair();
            BCECPrivateKey priv = (BCECPrivateKey)pairX.getPrivate();
            BCECPublicKey pub = (BCECPublicKey)pairX.getPublic();
            newKey.PublicKey = pub.getQ();
            newKey.PrivateKey = priv.getD();
            return newKey;
        }
        catch (Exception e) {
            throw new TpmException("Bad alg:", e);
        }
    }

    static String ecTpmToBc(TPM_ECC_CURVE curve) {
        switch (curve.asEnum()) {
            case NIST_P256: {
                return "P-256";
            }
        }
        throw new TpmException("Unsupported alg");
    }

    static String ecTpmToBc(TPM_ALG_ID id) {
        switch (id.asEnum()) {
            case ECDSA: {
                return "ECDSA";
            }
            case ECDH: {
                return "ECDH";
            }
        }
        throw new TpmException("Unsupported alg");
    }

    static int ecTpmKeyStrength(TPM_ECC_CURVE curve) {
        switch (curve.asEnum()) {
            case NIST_P256: {
                return 256;
            }
        }
        throw new TpmException("Unsupported alg");
    }

    static byte[] bigIntToTpmInt(BigInteger x, int keySize) {
        int numBytes = keySize / 8;
        byte[] key = x.toByteArray();
        byte[] ret = new byte[numBytes];
        int offset = key.length - numBytes;
        if (offset > 5 || offset < -5) {
            throw new RuntimeException("help");
        }
        for (int j = 0; j < numBytes; ++j) {
            if (j + offset < 0) continue;
            ret[j] = key[j + offset];
        }
        return ret;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static class ECCKeyPair {
        public org.bouncycastle.math.ec.ECPoint PublicKey;
        public BigInteger PrivateKey;
    }

    public static class RsaKeyPair {
        public BigInteger PublicKey;
        public BigInteger PrivateKey;
    }
}

