/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.util.Map;
import tss.TpmEnum;

public abstract class TpmAttribute<T extends TpmAttribute<T>>
extends TpmEnum<T> {
    protected TpmAttribute(int value, Enum<?> nameAsEnum, TpmEnum.ValueMap<T> values) {
        super(value, nameAsEnum, values);
    }

    @SafeVarargs
    protected TpmAttribute(TpmEnum.ValueMap<T> values, T ... attrs) {
        super(0, null, null);
        for (T a : attrs) {
            this.Value |= ((TpmAttribute)a).Value;
        }
        this.updateName(values);
    }

    protected TpmAttribute(int value, TpmEnum.ValueMap<T> values) {
        super(value, values);
        this.Name = null;
        this.updateName(values);
    }

    protected static <T extends TpmEnum<T>> T fromInt(int value, TpmEnum.ValueMap<T> values, Class<T> cls) {
        return null;
    }

    protected static <T extends TpmAttribute<T>> T attrFromInt(int value, TpmEnum.ValueMap<T> values, Class<T> cls) {
        TpmAttribute newAttr = (TpmAttribute)TpmEnum.fromInt(value, values, cls);
        newAttr.updateName(values);
        return (T)newAttr;
    }

    protected boolean hasAttr(TpmAttribute<T> attr) {
        return attr.Value == (this.Value & attr.Value);
    }

    protected T maskAttr(T attr, TpmEnum.ValueMap<T> values, Class<T> cls) {
        return TpmAttribute.attrFromInt(this.Value & ((TpmAttribute)attr).Value, values, cls);
    }

    private void updateName(String attrName) {
        this.Name = this.Name == null ? attrName : this.Name + " | " + attrName;
    }

    private void updateName(TpmEnum.ValueMap<T> values) {
        int matchedAttrs = 0;
        for (Map.Entry pair : values.entrySet()) {
            int key = (Integer)pair.getKey();
            if ((this.Value & key) == 0) continue;
            matchedAttrs |= key;
            this.updateName(((TpmAttribute)pair.getValue()).Name);
        }
        int unmatchedAttrs = this.Value ^ matchedAttrs;
        if (unmatchedAttrs != 0) {
            this.updateName(Integer.toHexString(unmatchedAttrs));
        }
    }
}

