/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_CC;
import tss.tpm.TPM_ST;

public class CommandHeader
extends TpmStructure {
    public TPM_ST Tag;
    public int CommandSize;
    public TPM_CC CommandCode;

    public CommandHeader(TPM_ST _Tag, int _CommandSize, TPM_CC _CommandCode) {
        this.Tag = _Tag;
        this.CommandSize = _CommandSize;
        this.CommandCode = _CommandCode;
    }

    public CommandHeader() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.Tag.toTpm(buf);
        buf.write(this.CommandSize);
        this.CommandCode.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.Tag = TPM_ST.fromTpm(buf);
        this.CommandSize = buf.readInt(4);
        this.CommandCode = TPM_CC.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static CommandHeader fromTpm(byte[] x) {
        CommandHeader ret = new CommandHeader();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static CommandHeader fromTpm(InByteBuf buf) {
        CommandHeader ret = new CommandHeader();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("CommandHeader");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ST", "Tag", this.Tag);
        _p.add(d, "uint", "CommandSize", this.CommandSize);
        _p.add(d, "TPM_CC", "CommandCode", this.CommandCode);
    }
}

