/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_CREATION_DATA;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_TK_CREATION;
import tss.tpm.TPM_HANDLE;

public class CreatePrimaryResponse
extends TpmStructure {
    public TPM_HANDLE handle;
    public TPMT_PUBLIC outPublic;
    public TPMS_CREATION_DATA creationData;
    public byte[] creationHash;
    public TPMT_TK_CREATION creationTicket;
    public byte[] name;

    public CreatePrimaryResponse(TPM_HANDLE _handle, TPMT_PUBLIC _outPublic, TPMS_CREATION_DATA _creationData, byte[] _creationHash, TPMT_TK_CREATION _creationTicket, byte[] _name) {
        this.handle = _handle;
        this.outPublic = _outPublic;
        this.creationData = _creationData;
        this.creationHash = _creationHash;
        this.creationTicket = _creationTicket;
        this.name = _name;
    }

    public CreatePrimaryResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.handle.toTpm(buf);
        buf.writeInt(this.outPublic != null ? this.outPublic.toTpm().length : 0, 2);
        if (this.outPublic != null) {
            this.outPublic.toTpm(buf);
        }
        buf.writeInt(this.creationData != null ? this.creationData.toTpm().length : 0, 2);
        if (this.creationData != null) {
            this.creationData.toTpm(buf);
        }
        buf.writeInt(this.creationHash != null ? this.creationHash.length : 0, 2);
        if (this.creationHash != null) {
            buf.write(this.creationHash);
        }
        this.creationTicket.toTpm(buf);
        buf.writeInt(this.name != null ? this.name.length : 0, 2);
        if (this.name != null) {
            buf.write(this.name);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.handle = TPM_HANDLE.fromTpm(buf);
        int _outPublicSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _outPublicSize));
        this.outPublic = TPMT_PUBLIC.fromTpm(buf);
        buf.structSize.pop();
        int _creationDataSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack2 = buf.structSize;
        InByteBuf inByteBuf2 = buf;
        inByteBuf2.getClass();
        stack2.push(inByteBuf2.new InByteBuf.SizedStructInfo(buf.curPos(), _creationDataSize));
        this.creationData = TPMS_CREATION_DATA.fromTpm(buf);
        buf.structSize.pop();
        int _creationHashSize = buf.readInt(2);
        this.creationHash = new byte[_creationHashSize];
        buf.readArrayOfInts(this.creationHash, 1, _creationHashSize);
        this.creationTicket = TPMT_TK_CREATION.fromTpm(buf);
        int _nameSize = buf.readInt(2);
        this.name = new byte[_nameSize];
        buf.readArrayOfInts(this.name, 1, _nameSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static CreatePrimaryResponse fromTpm(byte[] x) {
        CreatePrimaryResponse ret = new CreatePrimaryResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static CreatePrimaryResponse fromTpm(InByteBuf buf) {
        CreatePrimaryResponse ret = new CreatePrimaryResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_CreatePrimary_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "TPMT_PUBLIC", "outPublic", this.outPublic);
        _p.add(d, "TPMS_CREATION_DATA", "creationData", this.creationData);
        _p.add(d, "byte", "creationHash", this.creationHash);
        _p.add(d, "TPMT_TK_CREATION", "creationTicket", this.creationTicket);
        _p.add(d, "byte", "name", this.name);
    }
}

