/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPMS_CREATION_DATA;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_TK_CREATION;

public class CreateResponse
extends TpmStructure {
    public TPM2B_PRIVATE outPrivate;
    public TPMT_PUBLIC outPublic;
    public TPMS_CREATION_DATA creationData;
    public byte[] creationHash;
    public TPMT_TK_CREATION creationTicket;

    public CreateResponse(TPM2B_PRIVATE _outPrivate, TPMT_PUBLIC _outPublic, TPMS_CREATION_DATA _creationData, byte[] _creationHash, TPMT_TK_CREATION _creationTicket) {
        this.outPrivate = _outPrivate;
        this.outPublic = _outPublic;
        this.creationData = _creationData;
        this.creationHash = _creationHash;
        this.creationTicket = _creationTicket;
    }

    public CreateResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.outPrivate.toTpm(buf);
        buf.writeInt(this.outPublic != null ? this.outPublic.toTpm().length : 0, 2);
        if (this.outPublic != null) {
            this.outPublic.toTpm(buf);
        }
        buf.writeInt(this.creationData != null ? this.creationData.toTpm().length : 0, 2);
        if (this.creationData != null) {
            this.creationData.toTpm(buf);
        }
        buf.writeInt(this.creationHash != null ? this.creationHash.length : 0, 2);
        if (this.creationHash != null) {
            buf.write(this.creationHash);
        }
        this.creationTicket.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.outPrivate = TPM2B_PRIVATE.fromTpm(buf);
        int _outPublicSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _outPublicSize));
        this.outPublic = TPMT_PUBLIC.fromTpm(buf);
        buf.structSize.pop();
        int _creationDataSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack2 = buf.structSize;
        InByteBuf inByteBuf2 = buf;
        inByteBuf2.getClass();
        stack2.push(inByteBuf2.new InByteBuf.SizedStructInfo(buf.curPos(), _creationDataSize));
        this.creationData = TPMS_CREATION_DATA.fromTpm(buf);
        buf.structSize.pop();
        int _creationHashSize = buf.readInt(2);
        this.creationHash = new byte[_creationHashSize];
        buf.readArrayOfInts(this.creationHash, 1, _creationHashSize);
        this.creationTicket = TPMT_TK_CREATION.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static CreateResponse fromTpm(byte[] x) {
        CreateResponse ret = new CreateResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static CreateResponse fromTpm(InByteBuf buf) {
        CreateResponse ret = new CreateResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Create_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM2B_PRIVATE", "outPrivate", this.outPrivate);
        _p.add(d, "TPMT_PUBLIC", "outPublic", this.outPublic);
        _p.add(d, "TPMS_CREATION_DATA", "creationData", this.creationData);
        _p.add(d, "byte", "creationHash", this.creationHash);
        _p.add(d, "TPMT_TK_CREATION", "creationTicket", this.creationTicket);
    }
}

