/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_TK_HASHCHECK;

public class HashResponse
extends TpmStructure {
    public byte[] outHash;
    public TPMT_TK_HASHCHECK validation;

    public HashResponse(byte[] _outHash, TPMT_TK_HASHCHECK _validation) {
        this.outHash = _outHash;
        this.validation = _validation;
    }

    public HashResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.outHash != null ? this.outHash.length : 0, 2);
        if (this.outHash != null) {
            buf.write(this.outHash);
        }
        this.validation.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _outHashSize = buf.readInt(2);
        this.outHash = new byte[_outHashSize];
        buf.readArrayOfInts(this.outHash, 1, _outHashSize);
        this.validation = TPMT_TK_HASHCHECK.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static HashResponse fromTpm(byte[] x) {
        HashResponse ret = new HashResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static HashResponse fromTpm(InByteBuf buf) {
        HashResponse ret = new HashResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Hash_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "outHash", this.outHash);
        _p.add(d, "TPMT_TK_HASHCHECK", "validation", this.validation);
    }
}

