/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;

public class ImportResponse
extends TpmStructure {
    public TPM2B_PRIVATE outPrivate;

    public ImportResponse(TPM2B_PRIVATE _outPrivate) {
        this.outPrivate = _outPrivate;
    }

    public ImportResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.outPrivate.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.outPrivate = TPM2B_PRIVATE.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static ImportResponse fromTpm(byte[] x) {
        ImportResponse ret = new ImportResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static ImportResponse fromTpm(InByteBuf buf) {
        ImportResponse ret = new ImportResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Import_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM2B_PRIVATE", "outPrivate", this.outPrivate);
    }
}

