/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ID_OBJECT;

public class MakeCredentialResponse
extends TpmStructure {
    public TPMS_ID_OBJECT credentialBlob;
    public byte[] secret;

    public MakeCredentialResponse(TPMS_ID_OBJECT _credentialBlob, byte[] _secret) {
        this.credentialBlob = _credentialBlob;
        this.secret = _secret;
    }

    public MakeCredentialResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.credentialBlob != null ? this.credentialBlob.toTpm().length : 0, 2);
        if (this.credentialBlob != null) {
            this.credentialBlob.toTpm(buf);
        }
        buf.writeInt(this.secret != null ? this.secret.length : 0, 2);
        if (this.secret != null) {
            buf.write(this.secret);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _credentialBlobSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _credentialBlobSize));
        this.credentialBlob = TPMS_ID_OBJECT.fromTpm(buf);
        buf.structSize.pop();
        int _secretSize = buf.readInt(2);
        this.secret = new byte[_secretSize];
        buf.readArrayOfInts(this.secret, 1, _secretSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static MakeCredentialResponse fromTpm(byte[] x) {
        MakeCredentialResponse ret = new MakeCredentialResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static MakeCredentialResponse fromTpm(InByteBuf buf) {
        MakeCredentialResponse ret = new MakeCredentialResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_MakeCredential_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_ID_OBJECT", "credentialBlob", this.credentialBlob);
        _p.add(d, "byte", "secret", this.secret);
    }
}

