/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class PCR_AllocateResponse
extends TpmStructure {
    public byte allocationSuccess;
    public int maxPCR;
    public int sizeNeeded;
    public int sizeAvailable;

    public PCR_AllocateResponse(byte _allocationSuccess, int _maxPCR, int _sizeNeeded, int _sizeAvailable) {
        this.allocationSuccess = _allocationSuccess;
        this.maxPCR = _maxPCR;
        this.sizeNeeded = _sizeNeeded;
        this.sizeAvailable = _sizeAvailable;
    }

    public PCR_AllocateResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.write(this.allocationSuccess);
        buf.write(this.maxPCR);
        buf.write(this.sizeNeeded);
        buf.write(this.sizeAvailable);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.allocationSuccess = (byte)buf.readInt(1);
        this.maxPCR = buf.readInt(4);
        this.sizeNeeded = buf.readInt(4);
        this.sizeAvailable = buf.readInt(4);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static PCR_AllocateResponse fromTpm(byte[] x) {
        PCR_AllocateResponse ret = new PCR_AllocateResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static PCR_AllocateResponse fromTpm(InByteBuf buf) {
        PCR_AllocateResponse ret = new PCR_AllocateResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PCR_Allocate_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "BYTE", "allocationSuccess", this.allocationSuccess);
        _p.add(d, "uint", "maxPCR", this.maxPCR);
        _p.add(d, "uint", "sizeNeeded", this.sizeNeeded);
        _p.add(d, "uint", "sizeAvailable", this.sizeAvailable);
    }
}

