/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_HA;

public class PCR_EventResponse
extends TpmStructure {
    public TPMT_HA[] digests;

    public PCR_EventResponse(TPMT_HA[] _digests) {
        this.digests = _digests;
    }

    public PCR_EventResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.digests != null ? this.digests.length : 0, 4);
        if (this.digests != null) {
            buf.writeArrayOfTpmObjects(this.digests);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _digestsCount = buf.readInt(4);
        this.digests = new TPMT_HA[_digestsCount];
        for (int j = 0; j < _digestsCount; ++j) {
            this.digests[j] = new TPMT_HA();
        }
        buf.readArrayOfTpmObjects(this.digests, _digestsCount);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static PCR_EventResponse fromTpm(byte[] x) {
        PCR_EventResponse ret = new PCR_EventResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static PCR_EventResponse fromTpm(InByteBuf buf) {
        PCR_EventResponse ret = new PCR_EventResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PCR_Event_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TpmHash", "digests", this.digests);
    }
}

