/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_HA;

public class PcrValue
extends TpmStructure {
    public int index;
    public TPMT_HA value;

    public PcrValue(int _index, TPMT_HA _value) {
        this.index = _index;
        this.value = _value;
    }

    public PcrValue() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.write(this.index);
        this.value.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.index = buf.readInt(4);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static PcrValue fromTpm(byte[] x) {
        PcrValue ret = new PcrValue();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static PcrValue fromTpm(InByteBuf buf) {
        PcrValue ret = new PcrValue();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("PcrValue");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "uint", "index", this.index);
        _p.add(d, "TpmHash", "value", this.value);
    }
}

