/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class RSA_DecryptResponse
extends TpmStructure {
    public byte[] message;

    public RSA_DecryptResponse(byte[] _message) {
        this.message = _message;
    }

    public RSA_DecryptResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.message != null ? this.message.length : 0, 2);
        if (this.message != null) {
            buf.write(this.message);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _messageSize = buf.readInt(2);
        this.message = new byte[_messageSize];
        buf.readArrayOfInts(this.message, 1, _messageSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static RSA_DecryptResponse fromTpm(byte[] x) {
        RSA_DecryptResponse ret = new RSA_DecryptResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static RSA_DecryptResponse fromTpm(InByteBuf buf) {
        RSA_DecryptResponse ret = new RSA_DecryptResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_RSA_Decrypt_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "message", this.message);
    }
}

