/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_TK_HASHCHECK;

public class SequenceCompleteResponse
extends TpmStructure {
    public byte[] result;
    public TPMT_TK_HASHCHECK validation;

    public SequenceCompleteResponse(byte[] _result, TPMT_TK_HASHCHECK _validation) {
        this.result = _result;
        this.validation = _validation;
    }

    public SequenceCompleteResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.result != null ? this.result.length : 0, 2);
        if (this.result != null) {
            buf.write(this.result);
        }
        this.validation.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _resultSize = buf.readInt(2);
        this.result = new byte[_resultSize];
        buf.readArrayOfInts(this.result, 1, _resultSize);
        this.validation = TPMT_TK_HASHCHECK.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static SequenceCompleteResponse fromTpm(byte[] x) {
        SequenceCompleteResponse ret = new SequenceCompleteResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static SequenceCompleteResponse fromTpm(InByteBuf buf) {
        SequenceCompleteResponse ret = new SequenceCompleteResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_SequenceComplete_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "result", this.result);
        _p.add(d, "TPMT_TK_HASHCHECK", "validation", this.validation);
    }
}

