/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_HMAC_REQUEST
extends TpmStructure {
    public TPM_HANDLE handle;
    public byte[] buffer;
    public TPM_ALG_ID hashAlg;

    public TPM2_HMAC_REQUEST(TPM_HANDLE _handle, byte[] _buffer, TPM_ALG_ID _hashAlg) {
        this.handle = _handle;
        this.buffer = _buffer;
        this.hashAlg = _hashAlg;
    }

    public TPM2_HMAC_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.handle.toTpm(buf);
        buf.writeInt(this.buffer != null ? this.buffer.length : 0, 2);
        if (this.buffer != null) {
            buf.write(this.buffer);
        }
        this.hashAlg.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.handle = TPM_HANDLE.fromTpm(buf);
        int _bufferSize = buf.readInt(2);
        this.buffer = new byte[_bufferSize];
        buf.readArrayOfInts(this.buffer, 1, _bufferSize);
        this.hashAlg = TPM_ALG_ID.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_HMAC_REQUEST fromTpm(byte[] x) {
        TPM2_HMAC_REQUEST ret = new TPM2_HMAC_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_HMAC_REQUEST fromTpm(InByteBuf buf) {
        TPM2_HMAC_REQUEST ret = new TPM2_HMAC_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_HMAC_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "byte", "buffer", this.buffer);
        _p.add(d, "TPM_ALG_ID", "hashAlg", this.hashAlg);
    }
}

