/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NV_PUBLIC;
import tss.tpm.TPM_HANDLE;

public class TPM2_NV_DefineSpace_REQUEST
extends TpmStructure {
    public TPM_HANDLE authHandle;
    public byte[] auth;
    public TPMS_NV_PUBLIC publicInfo;

    public TPM2_NV_DefineSpace_REQUEST(TPM_HANDLE _authHandle, byte[] _auth, TPMS_NV_PUBLIC _publicInfo) {
        this.authHandle = _authHandle;
        this.auth = _auth;
        this.publicInfo = _publicInfo;
    }

    public TPM2_NV_DefineSpace_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.authHandle.toTpm(buf);
        buf.writeInt(this.auth != null ? this.auth.length : 0, 2);
        if (this.auth != null) {
            buf.write(this.auth);
        }
        buf.writeInt(this.publicInfo != null ? this.publicInfo.toTpm().length : 0, 2);
        if (this.publicInfo != null) {
            this.publicInfo.toTpm(buf);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.authHandle = TPM_HANDLE.fromTpm(buf);
        int _authSize = buf.readInt(2);
        this.auth = new byte[_authSize];
        buf.readArrayOfInts(this.auth, 1, _authSize);
        int _publicInfoSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _publicInfoSize));
        this.publicInfo = TPMS_NV_PUBLIC.fromTpm(buf);
        buf.structSize.pop();
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_NV_DefineSpace_REQUEST fromTpm(byte[] x) {
        TPM2_NV_DefineSpace_REQUEST ret = new TPM2_NV_DefineSpace_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_NV_DefineSpace_REQUEST fromTpm(InByteBuf buf) {
        TPM2_NV_DefineSpace_REQUEST ret = new TPM2_NV_DefineSpace_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_NV_DefineSpace_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authHandle", this.authHandle);
        _p.add(d, "byte", "auth", this.auth);
        _p.add(d, "TPMS_NV_PUBLIC", "publicInfo", this.publicInfo);
    }
}

