/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicyNameHash_REQUEST
extends TpmStructure {
    public TPM_HANDLE policySession;
    public byte[] nameHash;

    public TPM2_PolicyNameHash_REQUEST(TPM_HANDLE _policySession, byte[] _nameHash) {
        this.policySession = _policySession;
        this.nameHash = _nameHash;
    }

    public TPM2_PolicyNameHash_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.policySession.toTpm(buf);
        buf.writeInt(this.nameHash != null ? this.nameHash.length : 0, 2);
        if (this.nameHash != null) {
            buf.write(this.nameHash);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.policySession = TPM_HANDLE.fromTpm(buf);
        int _nameHashSize = buf.readInt(2);
        this.nameHash = new byte[_nameHashSize];
        buf.readArrayOfInts(this.nameHash, 1, _nameHashSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PolicyNameHash_REQUEST fromTpm(byte[] x) {
        TPM2_PolicyNameHash_REQUEST ret = new TPM2_PolicyNameHash_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PolicyNameHash_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PolicyNameHash_REQUEST ret = new TPM2_PolicyNameHash_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicyNameHash_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte", "nameHash", this.nameHash);
    }
}

