/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicyTemplate_REQUEST
extends TpmStructure {
    public TPM_HANDLE policySession;
    public byte[] templateHash;

    public TPM2_PolicyTemplate_REQUEST(TPM_HANDLE _policySession, byte[] _templateHash) {
        this.policySession = _policySession;
        this.templateHash = _templateHash;
    }

    public TPM2_PolicyTemplate_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.policySession.toTpm(buf);
        buf.writeInt(this.templateHash != null ? this.templateHash.length : 0, 2);
        if (this.templateHash != null) {
            buf.write(this.templateHash);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.policySession = TPM_HANDLE.fromTpm(buf);
        int _templateHashSize = buf.readInt(2);
        this.templateHash = new byte[_templateHashSize];
        buf.readArrayOfInts(this.templateHash, 1, _templateHashSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PolicyTemplate_REQUEST fromTpm(byte[] x) {
        TPM2_PolicyTemplate_REQUEST ret = new TPM2_PolicyTemplate_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PolicyTemplate_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PolicyTemplate_REQUEST ret = new TPM2_PolicyTemplate_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicyTemplate_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte", "templateHash", this.templateHash);
    }
}

