/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_TK_AUTH;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicyTicket_REQUEST
extends TpmStructure {
    public TPM_HANDLE policySession;
    public byte[] timeout;
    public byte[] cpHashA;
    public byte[] policyRef;
    public byte[] authName;
    public TPMT_TK_AUTH ticket;

    public TPM2_PolicyTicket_REQUEST(TPM_HANDLE _policySession, byte[] _timeout, byte[] _cpHashA, byte[] _policyRef, byte[] _authName, TPMT_TK_AUTH _ticket) {
        this.policySession = _policySession;
        this.timeout = _timeout;
        this.cpHashA = _cpHashA;
        this.policyRef = _policyRef;
        this.authName = _authName;
        this.ticket = _ticket;
    }

    public TPM2_PolicyTicket_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.policySession.toTpm(buf);
        buf.writeInt(this.timeout != null ? this.timeout.length : 0, 2);
        if (this.timeout != null) {
            buf.write(this.timeout);
        }
        buf.writeInt(this.cpHashA != null ? this.cpHashA.length : 0, 2);
        if (this.cpHashA != null) {
            buf.write(this.cpHashA);
        }
        buf.writeInt(this.policyRef != null ? this.policyRef.length : 0, 2);
        if (this.policyRef != null) {
            buf.write(this.policyRef);
        }
        buf.writeInt(this.authName != null ? this.authName.length : 0, 2);
        if (this.authName != null) {
            buf.write(this.authName);
        }
        this.ticket.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.policySession = TPM_HANDLE.fromTpm(buf);
        int _timeoutSize = buf.readInt(2);
        this.timeout = new byte[_timeoutSize];
        buf.readArrayOfInts(this.timeout, 1, _timeoutSize);
        int _cpHashASize = buf.readInt(2);
        this.cpHashA = new byte[_cpHashASize];
        buf.readArrayOfInts(this.cpHashA, 1, _cpHashASize);
        int _policyRefSize = buf.readInt(2);
        this.policyRef = new byte[_policyRefSize];
        buf.readArrayOfInts(this.policyRef, 1, _policyRefSize);
        int _authNameSize = buf.readInt(2);
        this.authName = new byte[_authNameSize];
        buf.readArrayOfInts(this.authName, 1, _authNameSize);
        this.ticket = TPMT_TK_AUTH.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PolicyTicket_REQUEST fromTpm(byte[] x) {
        TPM2_PolicyTicket_REQUEST ret = new TPM2_PolicyTicket_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PolicyTicket_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PolicyTicket_REQUEST ret = new TPM2_PolicyTicket_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicyTicket_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte", "timeout", this.timeout);
        _p.add(d, "byte", "cpHashA", this.cpHashA);
        _p.add(d, "byte", "policyRef", this.policyRef);
        _p.add(d, "byte", "authName", this.authName);
        _p.add(d, "TPMT_TK_AUTH", "ticket", this.ticket);
    }
}

