/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPM_HANDLE;

public class TPM2_Rewrap_REQUEST
extends TpmStructure {
    public TPM_HANDLE oldParent;
    public TPM_HANDLE newParent;
    public TPM2B_PRIVATE inDuplicate;
    public byte[] name;
    public byte[] inSymSeed;

    public TPM2_Rewrap_REQUEST(TPM_HANDLE _oldParent, TPM_HANDLE _newParent, TPM2B_PRIVATE _inDuplicate, byte[] _name, byte[] _inSymSeed) {
        this.oldParent = _oldParent;
        this.newParent = _newParent;
        this.inDuplicate = _inDuplicate;
        this.name = _name;
        this.inSymSeed = _inSymSeed;
    }

    public TPM2_Rewrap_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.oldParent.toTpm(buf);
        this.newParent.toTpm(buf);
        this.inDuplicate.toTpm(buf);
        buf.writeInt(this.name != null ? this.name.length : 0, 2);
        if (this.name != null) {
            buf.write(this.name);
        }
        buf.writeInt(this.inSymSeed != null ? this.inSymSeed.length : 0, 2);
        if (this.inSymSeed != null) {
            buf.write(this.inSymSeed);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.oldParent = TPM_HANDLE.fromTpm(buf);
        this.newParent = TPM_HANDLE.fromTpm(buf);
        this.inDuplicate = TPM2B_PRIVATE.fromTpm(buf);
        int _nameSize = buf.readInt(2);
        this.name = new byte[_nameSize];
        buf.readArrayOfInts(this.name, 1, _nameSize);
        int _inSymSeedSize = buf.readInt(2);
        this.inSymSeed = new byte[_inSymSeedSize];
        buf.readArrayOfInts(this.inSymSeed, 1, _inSymSeedSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_Rewrap_REQUEST fromTpm(byte[] x) {
        TPM2_Rewrap_REQUEST ret = new TPM2_Rewrap_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_Rewrap_REQUEST fromTpm(InByteBuf buf) {
        TPM2_Rewrap_REQUEST ret = new TPM2_Rewrap_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Rewrap_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "oldParent", this.oldParent);
        _p.add(d, "TPM_HANDLE", "newParent", this.newParent);
        _p.add(d, "TPM2B_PRIVATE", "inDuplicate", this.inDuplicate);
        _p.add(d, "byte", "name", this.name);
        _p.add(d, "byte", "inSymSeed", this.inSymSeed);
    }
}

