/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_ALGORITHM;
import tss.tpm.TPM_ALG_ID;

public class TPMS_ALGORITHM_DESCRIPTION
extends TpmStructure {
    public TPM_ALG_ID alg;
    public TPMA_ALGORITHM attributes;

    public TPMS_ALGORITHM_DESCRIPTION(TPM_ALG_ID _alg, TPMA_ALGORITHM _attributes) {
        this.alg = _alg;
        this.attributes = _attributes;
    }

    public TPMS_ALGORITHM_DESCRIPTION() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.alg.toTpm(buf);
        this.attributes.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.alg = TPM_ALG_ID.fromTpm(buf);
        int _attributes = buf.readInt(4);
        this.attributes = TPMA_ALGORITHM.fromInt(_attributes);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_ALGORITHM_DESCRIPTION fromTpm(byte[] x) {
        TPMS_ALGORITHM_DESCRIPTION ret = new TPMS_ALGORITHM_DESCRIPTION();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_ALGORITHM_DESCRIPTION fromTpm(InByteBuf buf) {
        TPMS_ALGORITHM_DESCRIPTION ret = new TPMS_ALGORITHM_DESCRIPTION();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_ALGORITHM_DESCRIPTION");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "alg", this.alg);
        _p.add(d, "TPMA_ALGORITHM", "attributes", this.attributes);
    }
}

