/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ENC_SCHEME_OAEP;
import tss.tpm.TPMS_ENC_SCHEME_RSAES;
import tss.tpm.TPMS_KEY_SCHEME_ECDH;
import tss.tpm.TPMS_KEY_SCHEME_ECMQV;
import tss.tpm.TPMS_NULL_ASYM_SCHEME;
import tss.tpm.TPMS_NULL_KDF_SCHEME;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SCHEME_KDF1_SP800_108;
import tss.tpm.TPMS_SCHEME_KDF1_SP800_56A;
import tss.tpm.TPMS_SCHEME_KDF2;
import tss.tpm.TPMS_SCHEME_MGF1;
import tss.tpm.TPMS_SIG_SCHEME_ECDAA;
import tss.tpm.TPMS_SIG_SCHEME_ECDSA;
import tss.tpm.TPMS_SIG_SCHEME_ECSCHNORR;
import tss.tpm.TPMS_SIG_SCHEME_RSAPSS;
import tss.tpm.TPMS_SIG_SCHEME_RSASSA;
import tss.tpm.TPMS_SIG_SCHEME_SM2;
import tss.tpm.TPMU_ASYM_SCHEME;
import tss.tpm.TPMU_KDF_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_ECC_CURVE;

public class TPMS_ALGORITHM_DETAIL_ECC
extends TpmStructure {
    public TPM_ECC_CURVE curveID;
    public short keySize;
    public TPMU_KDF_SCHEME kdf;
    public TPMU_ASYM_SCHEME sign;
    public byte[] p;
    public byte[] a;
    public byte[] b;
    public byte[] gX;
    public byte[] gY;
    public byte[] n;
    public byte[] h;

    public TPMS_ALGORITHM_DETAIL_ECC(TPM_ECC_CURVE _curveID, int _keySize, TPMU_KDF_SCHEME _kdf, TPMU_ASYM_SCHEME _sign, byte[] _p, byte[] _a, byte[] _b, byte[] _gX, byte[] _gY, byte[] _n, byte[] _h) {
        this.curveID = _curveID;
        this.keySize = (short)_keySize;
        this.kdf = _kdf;
        this.sign = _sign;
        this.p = _p;
        this.a = _a;
        this.b = _b;
        this.gX = _gX;
        this.gY = _gY;
        this.n = _n;
        this.h = _h;
    }

    public TPMS_ALGORITHM_DETAIL_ECC() {
    }

    public int GetUnionSelector_kdf() {
        if (this.kdf instanceof TPMS_SCHEME_MGF1) {
            return 7;
        }
        if (this.kdf instanceof TPMS_SCHEME_KDF1_SP800_56A) {
            return 32;
        }
        if (this.kdf instanceof TPMS_SCHEME_KDF2) {
            return 33;
        }
        if (this.kdf instanceof TPMS_SCHEME_KDF1_SP800_108) {
            return 34;
        }
        if (this.kdf instanceof TPMS_NULL_KDF_SCHEME) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    public int GetUnionSelector_sign() {
        if (this.sign instanceof TPMS_KEY_SCHEME_ECDH) {
            return 25;
        }
        if (this.sign instanceof TPMS_KEY_SCHEME_ECMQV) {
            return 29;
        }
        if (this.sign instanceof TPMS_SIG_SCHEME_RSASSA) {
            return 20;
        }
        if (this.sign instanceof TPMS_SIG_SCHEME_RSAPSS) {
            return 22;
        }
        if (this.sign instanceof TPMS_SIG_SCHEME_ECDSA) {
            return 24;
        }
        if (this.sign instanceof TPMS_SIG_SCHEME_ECDAA) {
            return 26;
        }
        if (this.sign instanceof TPMS_SIG_SCHEME_SM2) {
            return 27;
        }
        if (this.sign instanceof TPMS_SIG_SCHEME_ECSCHNORR) {
            return 28;
        }
        if (this.sign instanceof TPMS_ENC_SCHEME_RSAES) {
            return 21;
        }
        if (this.sign instanceof TPMS_ENC_SCHEME_OAEP) {
            return 23;
        }
        if (this.sign instanceof TPMS_SCHEME_HASH) {
            return Short.MAX_VALUE;
        }
        if (this.sign instanceof TPMS_NULL_ASYM_SCHEME) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.curveID.toTpm(buf);
        buf.write(this.keySize);
        buf.writeInt(this.GetUnionSelector_kdf(), 2);
        this.kdf.toTpm(buf);
        buf.writeInt(this.GetUnionSelector_sign(), 2);
        this.sign.toTpm(buf);
        buf.writeInt(this.p != null ? this.p.length : 0, 2);
        if (this.p != null) {
            buf.write(this.p);
        }
        buf.writeInt(this.a != null ? this.a.length : 0, 2);
        if (this.a != null) {
            buf.write(this.a);
        }
        buf.writeInt(this.b != null ? this.b.length : 0, 2);
        if (this.b != null) {
            buf.write(this.b);
        }
        buf.writeInt(this.gX != null ? this.gX.length : 0, 2);
        if (this.gX != null) {
            buf.write(this.gX);
        }
        buf.writeInt(this.gY != null ? this.gY.length : 0, 2);
        if (this.gY != null) {
            buf.write(this.gY);
        }
        buf.writeInt(this.n != null ? this.n.length : 0, 2);
        if (this.n != null) {
            buf.write(this.n);
        }
        buf.writeInt(this.h != null ? this.h.length : 0, 2);
        if (this.h != null) {
            buf.write(this.h);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.curveID = TPM_ECC_CURVE.fromTpm(buf);
        this.keySize = (short)buf.readInt(2);
        int _kdfScheme = buf.readInt(2);
        this.kdf = null;
        if (_kdfScheme == TPM_ALG_ID.MGF1.toInt()) {
            this.kdf = new TPMS_SCHEME_MGF1();
        } else if (_kdfScheme == TPM_ALG_ID.KDF1_SP800_56A.toInt()) {
            this.kdf = new TPMS_SCHEME_KDF1_SP800_56A();
        } else if (_kdfScheme == TPM_ALG_ID.KDF2.toInt()) {
            this.kdf = new TPMS_SCHEME_KDF2();
        } else if (_kdfScheme == TPM_ALG_ID.KDF1_SP800_108.toInt()) {
            this.kdf = new TPMS_SCHEME_KDF1_SP800_108();
        } else if (_kdfScheme == TPM_ALG_ID.NULL.toInt()) {
            this.kdf = new TPMS_NULL_KDF_SCHEME();
        }
        if (this.kdf == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_kdfScheme).name());
        }
        this.kdf.initFromTpm(buf);
        int _signScheme = buf.readInt(2);
        this.sign = null;
        if (_signScheme == TPM_ALG_ID.ECDH.toInt()) {
            this.sign = new TPMS_KEY_SCHEME_ECDH();
        } else if (_signScheme == TPM_ALG_ID.ECMQV.toInt()) {
            this.sign = new TPMS_KEY_SCHEME_ECMQV();
        } else if (_signScheme == TPM_ALG_ID.RSASSA.toInt()) {
            this.sign = new TPMS_SIG_SCHEME_RSASSA();
        } else if (_signScheme == TPM_ALG_ID.RSAPSS.toInt()) {
            this.sign = new TPMS_SIG_SCHEME_RSAPSS();
        } else if (_signScheme == TPM_ALG_ID.ECDSA.toInt()) {
            this.sign = new TPMS_SIG_SCHEME_ECDSA();
        } else if (_signScheme == TPM_ALG_ID.ECDAA.toInt()) {
            this.sign = new TPMS_SIG_SCHEME_ECDAA();
        } else if (_signScheme == TPM_ALG_ID.RSAES.toInt()) {
            this.sign = new TPMS_ENC_SCHEME_RSAES();
        } else if (_signScheme == TPM_ALG_ID.OAEP.toInt()) {
            this.sign = new TPMS_ENC_SCHEME_OAEP();
        } else if (_signScheme == TPM_ALG_ID.ANY.toInt()) {
            this.sign = new TPMS_SCHEME_HASH();
        } else if (_signScheme == TPM_ALG_ID.NULL.toInt()) {
            this.sign = new TPMS_NULL_ASYM_SCHEME();
        }
        if (this.sign == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_signScheme).name());
        }
        this.sign.initFromTpm(buf);
        int _pSize = buf.readInt(2);
        this.p = new byte[_pSize];
        buf.readArrayOfInts(this.p, 1, _pSize);
        int _aSize = buf.readInt(2);
        this.a = new byte[_aSize];
        buf.readArrayOfInts(this.a, 1, _aSize);
        int _bSize = buf.readInt(2);
        this.b = new byte[_bSize];
        buf.readArrayOfInts(this.b, 1, _bSize);
        int _gXSize = buf.readInt(2);
        this.gX = new byte[_gXSize];
        buf.readArrayOfInts(this.gX, 1, _gXSize);
        int _gYSize = buf.readInt(2);
        this.gY = new byte[_gYSize];
        buf.readArrayOfInts(this.gY, 1, _gYSize);
        int _nSize = buf.readInt(2);
        this.n = new byte[_nSize];
        buf.readArrayOfInts(this.n, 1, _nSize);
        int _hSize = buf.readInt(2);
        this.h = new byte[_hSize];
        buf.readArrayOfInts(this.h, 1, _hSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_ALGORITHM_DETAIL_ECC fromTpm(byte[] x) {
        TPMS_ALGORITHM_DETAIL_ECC ret = new TPMS_ALGORITHM_DETAIL_ECC();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_ALGORITHM_DETAIL_ECC fromTpm(InByteBuf buf) {
        TPMS_ALGORITHM_DETAIL_ECC ret = new TPMS_ALGORITHM_DETAIL_ECC();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_ALGORITHM_DETAIL_ECC");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ECC_CURVE", "curveID", this.curveID);
        _p.add(d, "ushort", "keySize", this.keySize);
        _p.add(d, "TPMU_KDF_SCHEME", "kdf", this.kdf);
        _p.add(d, "TPMU_ASYM_SCHEME", "sign", this.sign);
        _p.add(d, "byte", "p", this.p);
        _p.add(d, "byte", "a", this.a);
        _p.add(d, "byte", "b", this.b);
        _p.add(d, "byte", "gX", this.gX);
        _p.add(d, "byte", "gY", this.gY);
        _p.add(d, "byte", "n", this.n);
        _p.add(d, "byte", "h", this.h);
    }
}

