/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ENC_SCHEME_OAEP;
import tss.tpm.TPMS_ENC_SCHEME_RSAES;
import tss.tpm.TPMS_KEY_SCHEME_ECDH;
import tss.tpm.TPMS_KEY_SCHEME_ECMQV;
import tss.tpm.TPMS_NULL_ASYM_SCHEME;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SIG_SCHEME_ECDAA;
import tss.tpm.TPMS_SIG_SCHEME_ECDSA;
import tss.tpm.TPMS_SIG_SCHEME_ECSCHNORR;
import tss.tpm.TPMS_SIG_SCHEME_RSAPSS;
import tss.tpm.TPMS_SIG_SCHEME_RSASSA;
import tss.tpm.TPMS_SIG_SCHEME_SM2;
import tss.tpm.TPMT_SYM_DEF_OBJECT;
import tss.tpm.TPMU_ASYM_SCHEME;
import tss.tpm.TPMU_PUBLIC_PARMS;
import tss.tpm.TPM_ALG_ID;

public class TPMS_ASYM_PARMS
extends TpmStructure
implements TPMU_PUBLIC_PARMS {
    public TPMT_SYM_DEF_OBJECT symmetric;
    public TPMU_ASYM_SCHEME scheme;

    public TPMS_ASYM_PARMS(TPMT_SYM_DEF_OBJECT _symmetric, TPMU_ASYM_SCHEME _scheme) {
        this.symmetric = _symmetric;
        this.scheme = _scheme;
    }

    public TPMS_ASYM_PARMS() {
    }

    public int GetUnionSelector_scheme() {
        if (this.scheme instanceof TPMS_KEY_SCHEME_ECDH) {
            return 25;
        }
        if (this.scheme instanceof TPMS_KEY_SCHEME_ECMQV) {
            return 29;
        }
        if (this.scheme instanceof TPMS_SIG_SCHEME_RSASSA) {
            return 20;
        }
        if (this.scheme instanceof TPMS_SIG_SCHEME_RSAPSS) {
            return 22;
        }
        if (this.scheme instanceof TPMS_SIG_SCHEME_ECDSA) {
            return 24;
        }
        if (this.scheme instanceof TPMS_SIG_SCHEME_ECDAA) {
            return 26;
        }
        if (this.scheme instanceof TPMS_SIG_SCHEME_SM2) {
            return 27;
        }
        if (this.scheme instanceof TPMS_SIG_SCHEME_ECSCHNORR) {
            return 28;
        }
        if (this.scheme instanceof TPMS_ENC_SCHEME_RSAES) {
            return 21;
        }
        if (this.scheme instanceof TPMS_ENC_SCHEME_OAEP) {
            return 23;
        }
        if (this.scheme instanceof TPMS_SCHEME_HASH) {
            return Short.MAX_VALUE;
        }
        if (this.scheme instanceof TPMS_NULL_ASYM_SCHEME) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.symmetric.toTpm(buf);
        buf.writeInt(this.GetUnionSelector_scheme(), 2);
        this.scheme.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.symmetric = TPMT_SYM_DEF_OBJECT.fromTpm(buf);
        int _schemeScheme = buf.readInt(2);
        this.scheme = null;
        if (_schemeScheme == TPM_ALG_ID.ECDH.toInt()) {
            this.scheme = new TPMS_KEY_SCHEME_ECDH();
        } else if (_schemeScheme == TPM_ALG_ID.ECMQV.toInt()) {
            this.scheme = new TPMS_KEY_SCHEME_ECMQV();
        } else if (_schemeScheme == TPM_ALG_ID.RSASSA.toInt()) {
            this.scheme = new TPMS_SIG_SCHEME_RSASSA();
        } else if (_schemeScheme == TPM_ALG_ID.RSAPSS.toInt()) {
            this.scheme = new TPMS_SIG_SCHEME_RSAPSS();
        } else if (_schemeScheme == TPM_ALG_ID.ECDSA.toInt()) {
            this.scheme = new TPMS_SIG_SCHEME_ECDSA();
        } else if (_schemeScheme == TPM_ALG_ID.ECDAA.toInt()) {
            this.scheme = new TPMS_SIG_SCHEME_ECDAA();
        } else if (_schemeScheme == TPM_ALG_ID.RSAES.toInt()) {
            this.scheme = new TPMS_ENC_SCHEME_RSAES();
        } else if (_schemeScheme == TPM_ALG_ID.OAEP.toInt()) {
            this.scheme = new TPMS_ENC_SCHEME_OAEP();
        } else if (_schemeScheme == TPM_ALG_ID.ANY.toInt()) {
            this.scheme = new TPMS_SCHEME_HASH();
        } else if (_schemeScheme == TPM_ALG_ID.NULL.toInt()) {
            this.scheme = new TPMS_NULL_ASYM_SCHEME();
        }
        if (this.scheme == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_schemeScheme).name());
        }
        this.scheme.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_ASYM_PARMS fromTpm(byte[] x) {
        TPMS_ASYM_PARMS ret = new TPMS_ASYM_PARMS();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_ASYM_PARMS fromTpm(InByteBuf buf) {
        TPMS_ASYM_PARMS ret = new TPMS_ASYM_PARMS();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_ASYM_PARMS");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMT_SYM_DEF_OBJECT", "symmetric", this.symmetric);
        _p.add(d, "TPMU_ASYM_SCHEME", "scheme", this.scheme);
    }
}

