/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPML_ALG_PROPERTY;
import tss.tpm.TPML_CC;
import tss.tpm.TPML_CCA;
import tss.tpm.TPML_ECC_CURVE;
import tss.tpm.TPML_HANDLE;
import tss.tpm.TPML_PCR_SELECTION;
import tss.tpm.TPML_TAGGED_PCR_PROPERTY;
import tss.tpm.TPML_TAGGED_POLICY;
import tss.tpm.TPML_TAGGED_TPM_PROPERTY;
import tss.tpm.TPMU_CAPABILITIES;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_CAP;

public class TPMS_CAPABILITY_DATA
extends TpmStructure {
    public TPMU_CAPABILITIES data;

    public TPMS_CAPABILITY_DATA(TPMU_CAPABILITIES _data) {
        this.data = _data;
    }

    public TPMS_CAPABILITY_DATA() {
    }

    public int GetUnionSelector_data() {
        if (this.data instanceof TPML_ALG_PROPERTY) {
            return 0;
        }
        if (this.data instanceof TPML_HANDLE) {
            return 1;
        }
        if (this.data instanceof TPML_CCA) {
            return 2;
        }
        if (this.data instanceof TPML_CC) {
            return 3;
        }
        if (this.data instanceof TPML_CC) {
            return 4;
        }
        if (this.data instanceof TPML_PCR_SELECTION) {
            return 5;
        }
        if (this.data instanceof TPML_TAGGED_TPM_PROPERTY) {
            return 6;
        }
        if (this.data instanceof TPML_TAGGED_PCR_PROPERTY) {
            return 7;
        }
        if (this.data instanceof TPML_ECC_CURVE) {
            return 8;
        }
        if (this.data instanceof TPML_TAGGED_POLICY) {
            return 9;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.GetUnionSelector_data(), 4);
        this.data.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _capability = buf.readInt(4);
        this.data = null;
        if (_capability == TPM_CAP.ALGS.toInt()) {
            this.data = new TPML_ALG_PROPERTY();
        } else if (_capability == TPM_CAP.HANDLES.toInt()) {
            this.data = new TPML_HANDLE();
        } else if (_capability == TPM_CAP.COMMANDS.toInt()) {
            this.data = new TPML_CCA();
        } else if (_capability == TPM_CAP.PP_COMMANDS.toInt()) {
            this.data = new TPML_CC();
        } else if (_capability == TPM_CAP.AUDIT_COMMANDS.toInt()) {
            this.data = new TPML_CC();
        } else if (_capability == TPM_CAP.PCRS.toInt()) {
            this.data = new TPML_PCR_SELECTION();
        } else if (_capability == TPM_CAP.TPM_PROPERTIES.toInt()) {
            this.data = new TPML_TAGGED_TPM_PROPERTY();
        } else if (_capability == TPM_CAP.PCR_PROPERTIES.toInt()) {
            this.data = new TPML_TAGGED_PCR_PROPERTY();
        } else if (_capability == TPM_CAP.ECC_CURVES.toInt()) {
            this.data = new TPML_ECC_CURVE();
        } else if (_capability == TPM_CAP.AUTH_POLICIES.toInt()) {
            this.data = new TPML_TAGGED_POLICY();
        }
        if (this.data == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_capability).name());
        }
        this.data.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_CAPABILITY_DATA fromTpm(byte[] x) {
        TPMS_CAPABILITY_DATA ret = new TPMS_CAPABILITY_DATA();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_CAPABILITY_DATA fromTpm(InByteBuf buf) {
        TPMS_CAPABILITY_DATA ret = new TPMS_CAPABILITY_DATA();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_CAPABILITY_DATA");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMU_CAPABILITIES", "data", this.data);
    }
}

