/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class TPMS_CLOCK_INFO
extends TpmStructure {
    public long clock;
    public int resetCount;
    public int restartCount;
    public byte safe;

    public TPMS_CLOCK_INFO(long _clock, int _resetCount, int _restartCount, byte _safe) {
        this.clock = _clock;
        this.resetCount = _resetCount;
        this.restartCount = _restartCount;
        this.safe = _safe;
    }

    public TPMS_CLOCK_INFO() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.write(this.clock);
        buf.write(this.resetCount);
        buf.write(this.restartCount);
        buf.write(this.safe);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.clock = buf.readLong();
        this.resetCount = buf.readInt(4);
        this.restartCount = buf.readInt(4);
        this.safe = (byte)buf.readInt(1);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_CLOCK_INFO fromTpm(byte[] x) {
        TPMS_CLOCK_INFO ret = new TPMS_CLOCK_INFO();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_CLOCK_INFO fromTpm(InByteBuf buf) {
        TPMS_CLOCK_INFO ret = new TPMS_CLOCK_INFO();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_CLOCK_INFO");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "ulong", "clock", this.clock);
        _p.add(d, "uint", "resetCount", this.resetCount);
        _p.add(d, "uint", "restartCount", this.restartCount);
        _p.add(d, "BYTE", "safe", this.safe);
    }
}

