/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NULL_SCHEME_KEYEDHASH;
import tss.tpm.TPMS_SCHEME_HMAC;
import tss.tpm.TPMS_SCHEME_XOR;
import tss.tpm.TPMU_SCHEME_KEYEDHASH;
import tss.tpm.TPM_ALG_ID;

public class TPMT_KEYEDHASH_SCHEME
extends TpmStructure {
    public TPMU_SCHEME_KEYEDHASH details;

    public TPMT_KEYEDHASH_SCHEME(TPMU_SCHEME_KEYEDHASH _details) {
        this.details = _details;
    }

    public TPMT_KEYEDHASH_SCHEME() {
    }

    public int GetUnionSelector_details() {
        if (this.details instanceof TPMS_SCHEME_HMAC) {
            return 5;
        }
        if (this.details instanceof TPMS_SCHEME_XOR) {
            return 10;
        }
        if (this.details instanceof TPMS_NULL_SCHEME_KEYEDHASH) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.GetUnionSelector_details(), 2);
        this.details.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _scheme = buf.readInt(2);
        this.details = null;
        if (_scheme == TPM_ALG_ID.HMAC.toInt()) {
            this.details = new TPMS_SCHEME_HMAC();
        } else if (_scheme == TPM_ALG_ID.XOR.toInt()) {
            this.details = new TPMS_SCHEME_XOR();
        } else if (_scheme == TPM_ALG_ID.NULL.toInt()) {
            this.details = new TPMS_NULL_SCHEME_KEYEDHASH();
        }
        if (this.details == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_scheme).name());
        }
        this.details.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMT_KEYEDHASH_SCHEME fromTpm(byte[] x) {
        TPMT_KEYEDHASH_SCHEME ret = new TPMT_KEYEDHASH_SCHEME();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMT_KEYEDHASH_SCHEME fromTpm(InByteBuf buf) {
        TPMT_KEYEDHASH_SCHEME ret = new TPMT_KEYEDHASH_SCHEME();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_KEYEDHASH_SCHEME");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMU_SCHEME_KEYEDHASH", "details", this.details);
    }
}

