/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_SENSITIVE;

public class TssObject
extends TpmStructure {
    public TPMT_PUBLIC Public;
    public TPMT_SENSITIVE Sensitive;
    public TPM2B_PRIVATE Private;

    public TssObject(TPMT_PUBLIC _Public, TPMT_SENSITIVE _Sensitive, TPM2B_PRIVATE _Private) {
        this.Public = _Public;
        this.Sensitive = _Sensitive;
        this.Private = _Private;
    }

    public TssObject() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.Public.toTpm(buf);
        this.Sensitive.toTpm(buf);
        this.Private.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.Public = TPMT_PUBLIC.fromTpm(buf);
        this.Sensitive = TPMT_SENSITIVE.fromTpm(buf);
        this.Private = TPM2B_PRIVATE.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TssObject fromTpm(byte[] x) {
        TssObject ret = new TssObject();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TssObject fromTpm(InByteBuf buf) {
        TssObject ret = new TssObject();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TssObject");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMT_PUBLIC", "Public", this.Public);
        _p.add(d, "TPMT_SENSITIVE", "Sensitive", this.Sensitive);
        _p.add(d, "TPM2B_PRIVATE", "Private", this.Private);
    }
}

