/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.sqlmapper.apt;

import com.github.mygreen.sqlmapper.apt.model.EntityMetamodel;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class AptUtils {
    public static boolean isInstanceField(Element element) {
        if (element.getKind() != ElementKind.FIELD) {
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        return !element.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static String getPackageClassNameSeparator(EntityMetamodel entityModel) {
        return entityModel.getType().isStaticInnerClass() ? "$" : ".";
    }

    public static void extractSuperClassTypes(TypeMirror type, Types typeUtils, List<TypeMirror> superTypes) {
        if (type.toString().equals(Object.class.getCanonicalName())) {
            return;
        }
        List<? extends TypeMirror> list = typeUtils.directSupertypes(type);
        for (TypeMirror typeMirror : list) {
            if (!superTypes.contains(typeMirror)) {
                superTypes.add(typeMirror);
            }
            AptUtils.extractSuperClassTypes(typeMirror, typeUtils, superTypes);
        }
    }
}

