/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.sqlmapper.apt;

import com.github.mygreen.sqlmapper.apt.AptUtils;
import com.github.mygreen.sqlmapper.apt.MetamodelConfig;
import com.github.mygreen.sqlmapper.apt.model.AptType;
import com.github.mygreen.sqlmapper.apt.model.EntityMetamodel;
import com.github.mygreen.sqlmapper.apt.model.PropertyMetamodel;
import com.github.mygreen.sqlmapper.core.util.NameUtils;
import com.github.mygreen.sqlmapper.metamodel.BooleanPath;
import com.github.mygreen.sqlmapper.metamodel.EntityPathBase;
import com.github.mygreen.sqlmapper.metamodel.EnumPath;
import com.github.mygreen.sqlmapper.metamodel.GeneralPath;
import com.github.mygreen.sqlmapper.metamodel.LocalDatePath;
import com.github.mygreen.sqlmapper.metamodel.LocalDateTimePath;
import com.github.mygreen.sqlmapper.metamodel.LocalTimePath;
import com.github.mygreen.sqlmapper.metamodel.NumberPath;
import com.github.mygreen.sqlmapper.metamodel.SqlDatePath;
import com.github.mygreen.sqlmapper.metamodel.SqlTimePath;
import com.github.mygreen.sqlmapper.metamodel.SqlTimestampPath;
import com.github.mygreen.sqlmapper.metamodel.StringPath;
import com.github.mygreen.sqlmapper.metamodel.UtilDatePath;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;

public class EntitySpecFactory {
    private final Messager messager;
    private final MetamodelConfig metamodelConfig;

    public TypeSpec create(EntityMetamodel entityModel) {
        ArrayList<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
        for (PropertyMetamodel propertyModel : entityModel.getProperties()) {
            fieldSpecs.add(this.createFieldSpec(propertyModel));
        }
        if (entityModel.isEmbeddable()) {
            return this.createTypeSpecAsEmbeddeable(entityModel, fieldSpecs);
        }
        if (entityModel.getType().isAbstract()) {
            return this.createTypeSpecAsAbstract(entityModel, fieldSpecs);
        }
        return this.createTypeSpecAsNormal(entityModel, fieldSpecs);
    }

    private FieldSpec createFieldSpec(PropertyMetamodel propertyModel) {
        FieldSpec filedSpec;
        AptType propertyType = propertyModel.getPropertyType();
        if (propertyModel.isEmbedded()) {
            String embeddedEntityMetamodelName = this.resolveEntityMetamodelName(propertyType.getSimpleName());
            ClassName embeddedEntityClassName = ClassName.bestGuess((String)embeddedEntityMetamodelName);
            filedSpec = FieldSpec.builder((TypeName)embeddedEntityClassName, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("new $T(this, $S)", new Object[]{embeddedEntityClassName, propertyModel.getPropertyName()}).build();
        } else if (propertyType.isInheritanceOf(String.class)) {
            filedSpec = FieldSpec.builder(StringPath.class, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createString($S)", new Object[]{propertyModel.getPropertyName()}).build();
        } else if (propertyType.isInheritanceOf(Number.class) || propertyType.isPrimitiveNumber()) {
            ParameterizedTypeName filedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(NumberPath.class), (TypeName[])new TypeName[]{propertyType.getWrapperTypeName()});
            filedSpec = FieldSpec.builder((TypeName)filedTypeName, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createNumber($S, $T.class)", new Object[]{propertyModel.getPropertyName(), propertyType.getWrapperTypeName()}).build();
        } else if (propertyType.isInheritanceOf(Boolean.class) || propertyType.isPrimitiveBoolean()) {
            filedSpec = FieldSpec.builder(BooleanPath.class, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createBoolean($S)", new Object[]{propertyModel.getPropertyName()}).build();
        } else if (propertyType.isEnum()) {
            ParameterizedTypeName filedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(EnumPath.class), (TypeName[])new TypeName[]{propertyType.getTypeName()});
            filedSpec = FieldSpec.builder((TypeName)filedTypeName, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createEnum($S, $T.class)", new Object[]{propertyModel.getPropertyName(), propertyType.getTypeName()}).build();
        } else if (propertyType.isInheritanceOf(Timestamp.class)) {
            filedSpec = FieldSpec.builder(SqlTimestampPath.class, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createSqlTimestamp($S)", new Object[]{propertyModel.getPropertyName()}).build();
        } else if (propertyType.isInheritanceOf(Time.class)) {
            filedSpec = FieldSpec.builder(SqlTimePath.class, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createSqlTime($S)", new Object[]{propertyModel.getPropertyName()}).build();
        } else if (propertyType.isInheritanceOf(Date.class)) {
            filedSpec = FieldSpec.builder(SqlDatePath.class, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createSqlDate($S)", new Object[]{propertyModel.getPropertyName()}).build();
        } else if (propertyType.isInheritanceOf(java.util.Date.class)) {
            filedSpec = FieldSpec.builder(UtilDatePath.class, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createUtilDate($S)", new Object[]{propertyModel.getPropertyName()}).build();
        } else if (propertyType.isInheritanceOf(LocalDate.class)) {
            filedSpec = FieldSpec.builder(LocalDatePath.class, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createLocalDate($S)", new Object[]{propertyModel.getPropertyName()}).build();
        } else if (propertyType.isInheritanceOf(LocalTime.class)) {
            filedSpec = FieldSpec.builder(LocalTimePath.class, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createLocalTime($S)", new Object[]{propertyModel.getPropertyName()}).build();
        } else if (propertyType.isInheritanceOf(LocalDateTime.class)) {
            filedSpec = FieldSpec.builder(LocalDateTimePath.class, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createLocalDateTime($S)", new Object[]{propertyModel.getPropertyName()}).build();
        } else {
            ParameterizedTypeName filedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(GeneralPath.class), (TypeName[])new TypeName[]{propertyType.getTypeName()});
            filedSpec = FieldSpec.builder((TypeName)filedTypeName, (String)propertyModel.getPropertyName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createGeneral($S, $T.class)", new Object[]{propertyModel.getPropertyName(), propertyType.getTypeName()}).build();
        }
        return filedSpec;
    }

    private TypeSpec createTypeSpecAsNormal(EntityMetamodel entityModel, List<FieldSpec> fieldSpecs) {
        ParameterizedTypeName metamodelSuperClass;
        ClassName entityType = entityModel.getType().asClassName();
        String entityMetamodelName = this.resolveEntityMetamodelName(entityModel.getClassName());
        if (entityModel.hasSuperClass()) {
            ClassName superClass = entityModel.getSuperClassType().asClassName();
            String metamodelSuperClassName = superClass.packageName() + AptUtils.getPackageClassNameSeparator(entityModel) + this.resolveEntityMetamodelName(superClass.simpleName());
            metamodelSuperClass = ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)metamodelSuperClassName), (TypeName[])new TypeName[]{TypeVariableName.get((String)entityType.simpleName())});
        } else {
            metamodelSuperClass = ParameterizedTypeName.get((ClassName)ClassName.get(EntityPathBase.class), (TypeName[])new TypeName[]{entityType});
        }
        MethodSpec consturctor1 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{entityType}), "type", new Modifier[0]).addParameter(String.class, "name", new Modifier[0]).addStatement("super(type, name)", new Object[0]).build();
        MethodSpec consturctor2 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "name", new Modifier[0]).addStatement("super($T.class, name)", new Object[]{entityType}).build();
        ClassName entityClassName = ClassName.bestGuess((String)entityMetamodelName);
        String entityFieldName = NameUtils.uncapitalize((String)entityModel.getClassName());
        FieldSpec entityFieldSpec = FieldSpec.builder((TypeName)entityClassName, (String)entityFieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $L($S)", new Object[]{entityMetamodelName, entityFieldName}).build();
        return TypeSpec.classBuilder((String)entityMetamodelName).addModifiers(this.resolveEntityTypeModifiers(entityModel)).superclass((TypeName)metamodelSuperClass).addAnnotation(this.createGeneratorAnnoSpec()).addJavadoc("$L is SqlMapper's metamodel type for {@link $T}", new Object[]{entityMetamodelName, entityType}).addMethod(consturctor1).addMethod(consturctor2).addField(entityFieldSpec).addFields(fieldSpecs).addTypes(this.createStaticInnerTypeSpecs(entityModel)).build();
    }

    private TypeSpec createTypeSpecAsAbstract(EntityMetamodel entityModel, List<FieldSpec> fieldSpecs) {
        TypeVariableName classTypeVariable;
        ParameterizedTypeName metamodelSuperClass;
        ClassName entityType = entityModel.getType().asClassName();
        String entityMetamodelName = this.resolveEntityMetamodelName(entityModel.getClassName());
        if (entityModel.hasSuperClass()) {
            ClassName superClass = entityModel.getSuperClassType().asClassName();
            String metamodelSuperClassName = superClass.packageName() + AptUtils.getPackageClassNameSeparator(entityModel) + this.resolveEntityMetamodelName(superClass.simpleName());
            metamodelSuperClass = ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)metamodelSuperClassName), (TypeName[])new TypeName[]{TypeVariableName.get((String)"E")});
            classTypeVariable = TypeVariableName.get((String)"E", (TypeName[])new TypeName[]{entityType});
        } else {
            metamodelSuperClass = ParameterizedTypeName.get((ClassName)ClassName.get(EntityPathBase.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"E")});
            classTypeVariable = TypeVariableName.get((String)"E", (TypeName[])new TypeName[]{entityType});
        }
        MethodSpec consturctor1 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeVariableName.get((String)"E"))}), "type", new Modifier[0]).addParameter(String.class, "name", new Modifier[0]).addStatement("super(type, name)", new Object[0]).build();
        return TypeSpec.classBuilder((String)entityMetamodelName).addModifiers(this.resolveEntityTypeModifiers(entityModel)).superclass((TypeName)metamodelSuperClass).addTypeVariable(classTypeVariable).addAnnotation(this.createGeneratorAnnoSpec()).addJavadoc("$L is SqlMapper's metamodel type for {@link $T}", new Object[]{entityMetamodelName, entityType}).addMethod(consturctor1).addFields(fieldSpecs).addTypes(this.createStaticInnerTypeSpecs(entityModel)).build();
    }

    private TypeSpec createTypeSpecAsEmbeddeable(EntityMetamodel entityModel, List<FieldSpec> fieldSpecs) {
        ParameterizedTypeName metamodelSuperClass;
        ClassName entityType = entityModel.getType().asClassName();
        String entityMetamodelName = this.resolveEntityMetamodelName(entityModel.getClassName());
        if (entityModel.hasSuperClass()) {
            ClassName superClass = entityModel.getSuperClassType().asClassName();
            String metamodelSuperClassName = superClass.packageName() + AptUtils.getPackageClassNameSeparator(entityModel) + this.resolveEntityMetamodelName(superClass.simpleName());
            metamodelSuperClass = ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)metamodelSuperClassName), (TypeName[])new TypeName[]{TypeVariableName.get((String)entityType.simpleName())});
        } else {
            metamodelSuperClass = ParameterizedTypeName.get((ClassName)ClassName.get(EntityPathBase.class), (TypeName[])new TypeName[]{entityType});
        }
        MethodSpec consturctor1 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{entityType}), "type", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(EntityPathBase.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), "parent", new Modifier[0]).addParameter(String.class, "name", new Modifier[0]).addStatement("super(type, parent, name)", new Object[0]).build();
        MethodSpec consturctor2 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(EntityPathBase.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), "parent", new Modifier[0]).addParameter(String.class, "name", new Modifier[0]).addStatement("super($T.class, parent, name)", new Object[]{entityType}).build();
        return TypeSpec.classBuilder((String)entityMetamodelName).addModifiers(this.resolveEntityTypeModifiers(entityModel)).superclass((TypeName)metamodelSuperClass).addAnnotation(this.createGeneratorAnnoSpec()).addJavadoc("$L is SqlMapper's metamodel type for {@link $T}", new Object[]{entityMetamodelName, entityType}).addMethod(consturctor1).addMethod(consturctor2).addFields(fieldSpecs).addTypes(this.createStaticInnerTypeSpecs(entityModel)).build();
    }

    private List<TypeSpec> createStaticInnerTypeSpecs(EntityMetamodel parentEntityModel) {
        ArrayList<TypeSpec> list = new ArrayList<TypeSpec>();
        for (EntityMetamodel staticInnerEntityModel : parentEntityModel.getStaticInnerEntities()) {
            list.add(this.create(staticInnerEntityModel));
        }
        return list;
    }

    private Modifier[] resolveEntityTypeModifiers(EntityMetamodel entityModel) {
        ArrayList<Modifier> list = new ArrayList<Modifier>(1);
        list.add(Modifier.PUBLIC);
        if (entityModel.getType().isAbstract()) {
            list.add(Modifier.ABSTRACT);
        }
        if (entityModel.getType().isStaticInnerClass()) {
            list.add(Modifier.STATIC);
        }
        return list.toArray(new Modifier[list.size()]);
    }

    private String resolveEntityMetamodelName(String simpleClassName) {
        return this.metamodelConfig.getPrefix() + simpleClassName + this.metamodelConfig.getSuffix();
    }

    private AnnotationSpec createGeneratorAnnoSpec() {
        return AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"SqlMapper - EntityMetamodelGenerator"}).addMember("date", "$S", new Object[]{DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss").format(LocalDateTime.now())}).build();
    }

    public EntitySpecFactory(Messager messager, MetamodelConfig metamodelConfig) {
        this.messager = messager;
        this.metamodelConfig = metamodelConfig;
    }
}

