/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.sqlmapper.apt.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class AptType {
    private final TypeMirror typeMirror;
    private final Optional<Element> typeElement;
    private List<TypeMirror> superTypes = new ArrayList<TypeMirror>();

    public boolean isStaticInnerClass() {
        if (this.typeElement.isEmpty()) {
            return false;
        }
        Element element = this.typeElement.get();
        if (element.getKind() != ElementKind.CLASS) {
            return false;
        }
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public boolean isAbstract() {
        if (this.typeElement.isEmpty()) {
            return false;
        }
        Element element = this.typeElement.get();
        if (element.getKind() != ElementKind.CLASS) {
            return false;
        }
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isArray() {
        return this.typeMirror instanceof ArrayType;
    }

    public boolean isEnum() {
        return this.typeElement.map(t -> t.getKind()).map(k -> k == ElementKind.ENUM).orElse(false);
    }

    public boolean isPrimitive() {
        return this.typeMirror instanceof PrimitiveType;
    }

    public boolean isPrimitiveNumber() {
        if (!this.isPrimitive()) {
            return false;
        }
        switch (this.typeMirror.getKind()) {
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isPrimitiveBoolean() {
        if (!this.isPrimitive()) {
            return false;
        }
        return this.typeMirror.getKind() == TypeKind.BOOLEAN;
    }

    public boolean isInheritanceOf(Class<?> targetClass) {
        String targetClassName = targetClass.getCanonicalName();
        if (this.getCanonicalName().equals(targetClassName)) {
            return true;
        }
        for (TypeMirror superType : this.superTypes) {
            if (!superType.toString().equals(targetClassName)) continue;
            return true;
        }
        return false;
    }

    public String getCanonicalName() {
        return this.typeMirror.toString();
    }

    public String getSimpleName() {
        String name = this.typeMirror.toString();
        int index = name.lastIndexOf(".");
        if (index >= 0) {
            return name.substring(index + 1);
        }
        return name;
    }

    public ClassName asClassName() {
        return ClassName.get((TypeElement)((TypeElement)this.typeElement.orElseThrow()));
    }

    public TypeName getWrapperTypeName() {
        if (this.isPrimitive()) {
            return TypeName.get((TypeMirror)this.typeMirror).box();
        }
        return TypeName.get((TypeMirror)this.typeMirror);
    }

    public TypeName getTypeName() {
        return TypeName.get((TypeMirror)this.typeMirror);
    }

    public AptType(TypeMirror typeMirror, Optional<Element> typeElement) {
        this.typeMirror = typeMirror;
        this.typeElement = typeElement;
    }

    public void setSuperTypes(List<TypeMirror> superTypes) {
        this.superTypes = superTypes;
    }
}

