/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.sqlmapper.apt;

import com.github.mygreen.sqlmapper.apt.EntityMetamodelFactory;
import com.github.mygreen.sqlmapper.apt.EntitySpecFactory;
import com.github.mygreen.sqlmapper.apt.MetamodelConfig;
import com.github.mygreen.sqlmapper.apt.model.EntityMetamodel;
import com.github.mygreen.sqlmapper.core.annotation.Embeddable;
import com.github.mygreen.sqlmapper.core.annotation.Entity;
import com.github.mygreen.sqlmapper.core.annotation.MappedSuperclass;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedAnnotationTypes(value={"com.github.mygreen.sqlmapper.core.annotation.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class EntityMetamodelProcessor
extends AbstractProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityMetamodelProcessor.class);
    private Filer filer;
    private Messager messager;
    private MetamodelConfig metamodelConfig;
    private EntityMetamodelFactory entityMetamodelFactory;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.metamodelConfig = new MetamodelConfig(processingEnv.getOptions());
        this.entityMetamodelFactory = new EntityMetamodelFactory(processingEnv.getTypeUtils());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Running ");
        log.info("Running {}", (Object)this.getClass().getSimpleName());
        if (roundEnv.processingOver() || annotations.isEmpty()) {
            return false;
        }
        if (roundEnv.getRootElements() == null || roundEnv.getRootElements().isEmpty()) {
            log.info("No sources to process.");
            return false;
        }
        ArrayList<EntityMetamodel> entityModeles = new ArrayList<EntityMetamodel>();
        this.processEntityAnno(roundEnv, entityModeles);
        EntitySpecFactory specFactory = new EntitySpecFactory(this.messager, this.metamodelConfig);
        for (EntityMetamodel entityModel : entityModeles) {
            TypeSpec typeSpec = specFactory.create(entityModel);
            this.generateEntityMetaModel(typeSpec, entityModel);
        }
        return false;
    }

    private void processEntityAnno(RoundEnvironment roundEnv, List<EntityMetamodel> entityModeles) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Entity.class)) {
            try {
                entityModeles.add(this.entityMetamodelFactory.create((TypeElement)element));
            }
            catch (ClassNotFoundException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), element);
                log.error("fail entity meta model for @Entity.", (Throwable)e);
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(MappedSuperclass.class)) {
            try {
                entityModeles.add(this.entityMetamodelFactory.create((TypeElement)element));
            }
            catch (ClassNotFoundException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), element);
                log.error("fail entity meta model for @MappedSuperclass.", (Throwable)e);
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Embeddable.class)) {
            try {
                entityModeles.add(this.entityMetamodelFactory.create((TypeElement)element));
            }
            catch (ClassNotFoundException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), element);
                log.error("fail entity meta model for @Embeddable.", (Throwable)e);
            }
        }
        ArrayList<EntityMetamodel> innerEntityModeles = new ArrayList<EntityMetamodel>();
        Iterator<EntityMetamodel> iterator = entityModeles.iterator();
        while (iterator.hasNext()) {
            EntityMetamodel entityModel = iterator.next();
            if (!entityModel.getType().isStaticInnerClass()) continue;
            innerEntityModeles.add(entityModel);
            iterator.remove();
        }
        block10: for (EntityMetamodel innerEntityModel : innerEntityModeles) {
            for (EntityMetamodel parentEntityModel : entityModeles) {
                if (!innerEntityModel.getPackageName().equals(parentEntityModel.getFullName())) continue;
                parentEntityModel.add(innerEntityModel);
                continue block10;
            }
        }
    }

    private void generateEntityMetaModel(TypeSpec typeSpec, EntityMetamodel entityModel) {
        JavaFile javaFile = JavaFile.builder((String)entityModel.getPackageName(), (TypeSpec)typeSpec).indent(this.metamodelConfig.getIndent()).build();
        try {
            javaFile.writeTo(this.filer);
            log.info("generate Metamodel class - {}", (Object)entityModel.getFullName());
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.toString());
            log.error("fail write Metamodel class.", (Throwable)e);
        }
    }
}

