/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.sqlmapper.apt;

import com.github.mygreen.sqlmapper.apt.AptUtils;
import com.github.mygreen.sqlmapper.apt.model.AptType;
import com.github.mygreen.sqlmapper.apt.model.EntityMetamodel;
import com.github.mygreen.sqlmapper.apt.model.PropertyMetamodel;
import com.github.mygreen.sqlmapper.core.annotation.Embeddable;
import com.github.mygreen.sqlmapper.core.annotation.EmbeddedId;
import com.github.mygreen.sqlmapper.core.annotation.Entity;
import com.github.mygreen.sqlmapper.core.annotation.Lob;
import com.github.mygreen.sqlmapper.core.annotation.MappedSuperclass;
import com.github.mygreen.sqlmapper.core.annotation.Transient;
import java.util.ArrayList;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import lombok.Generated;

public class EntityMetamodelFactory {
    private final Types typeUtils;

    public EntityMetamodel create(TypeElement entityElement) throws ClassNotFoundException {
        EntityMetamodel entityModel = new EntityMetamodel();
        entityModel.setClassName(entityElement.getSimpleName().toString());
        Element enclosing = entityElement.getEnclosingElement();
        if (enclosing != null) {
            entityModel.setPackageName(enclosing.toString());
        }
        entityModel.setType(this.createAptType(entityElement.asType()));
        entityModel.setEntityAnno(entityElement.getAnnotation(Entity.class));
        entityModel.setMappedSuperclassAnno(entityElement.getAnnotation(MappedSuperclass.class));
        entityModel.setEmbeddableAnno(entityElement.getAnnotation(Embeddable.class));
        this.doSuperclass(entityModel, entityElement);
        this.doPropety(entityModel, entityElement);
        return entityModel;
    }

    private void doSuperclass(EntityMetamodel entityModel, TypeElement entityElement) {
        TypeMirror superclassType = entityElement.getSuperclass();
        if (superclassType.toString().equals(Object.class.getCanonicalName())) {
            return;
        }
        Element superclassElement = this.typeUtils.asElement(superclassType);
        if (superclassElement == null || !(superclassElement instanceof TypeElement)) {
            return;
        }
        TypeElement superTypeElement = (TypeElement)superclassElement;
        if (superTypeElement.getAnnotation(MappedSuperclass.class) != null) {
            entityModel.setSuperClassType(this.createAptType(superclassType));
        }
    }

    private void doPropety(EntityMetamodel entityModel, TypeElement entityElement) {
        for (Element element : entityElement.getEnclosedElements()) {
            if (!AptUtils.isInstanceField(element) || element.getAnnotation(Transient.class) != null) continue;
            entityModel.add(this.createPropertyModel((VariableElement)element));
        }
    }

    private PropertyMetamodel createPropertyModel(VariableElement fieldElement) {
        PropertyMetamodel propertyModel = new PropertyMetamodel();
        propertyModel.setPropertyName(fieldElement.getSimpleName().toString());
        TypeMirror type = fieldElement.asType();
        propertyModel.setPropertyType(this.createAptType(type));
        propertyModel.setEmbedded(fieldElement.getAnnotation(EmbeddedId.class) != null);
        propertyModel.setLob(fieldElement.getAnnotation(Lob.class) != null);
        return propertyModel;
    }

    private AptType createAptType(TypeMirror typeMirror) {
        AptType aptType = new AptType(typeMirror, Optional.ofNullable(this.typeUtils.asElement(typeMirror)));
        ArrayList<TypeMirror> superTypes = new ArrayList<TypeMirror>();
        AptUtils.extractSuperClassTypes(typeMirror, this.typeUtils, superTypes);
        aptType.setSuperTypes(superTypes);
        return aptType;
    }

    @Generated
    public EntityMetamodelFactory(Types typeUtils) {
        this.typeUtils = typeUtils;
    }
}

