/*
 * Decompiled with CFR 0.152.
 */
package com.github.nill14.utils.executor;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ReschedulableTask {
    private static final long EMPTY = 0L;
    private final ScheduledExecutorService executor;
    private final AtomicLong counter = new AtomicLong();
    private final Runnable command;

    public ReschedulableTask(ScheduledExecutorService executor, Runnable command) {
        this.executor = executor;
        this.command = command;
    }

    public void reschedule(long delay, TimeUnit unit) {
        long val = this.counter.incrementAndGet();
        this.executor.schedule(() -> {
            if (this.counter.compareAndSet(val, 0L)) {
                this.command.run();
            }
        }, delay, unit);
    }

    public void scheduleOnce(long delay, TimeUnit unit) {
        long val = this.counter.incrementAndGet();
        this.executor.schedule(() -> {
            if (val == 1L) {
                this.counter.set(0L);
                this.command.run();
            }
        }, delay, unit);
    }
}

