package com.pichs.xsql.processor;

import com.google.auto.service.AutoService;
import com.pichs.xsql.annotation.SqlTable;
import com.pichs.xsql.processor.javawriter.JavaWriter;
import com.pichs.xsql.processor.util.ClassGenerater;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoService(Processor.class)
public class XSqlProcessor extends AbstractProcessor {


    private Elements mElementsUtils;
    private Types mTypesUtils;
    private static Messager mMessager;
    private Filer mFiler;
    private ClassGenerater classGenerater;
    private JavaWriter jw;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        mFiler = processingEnvironment.getFiler();
        mElementsUtils = processingEnvironment.getElementUtils();
        mTypesUtils = processingEnvironment.getTypeUtils();
        mMessager = processingEnvironment.getMessager();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return super.getSupportedOptions();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        Set<String> set = new HashSet<>();
        set.add(SqlTable.class.getCanonicalName());
        return set;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        print("roundEnvironment.errorRaised(): " + roundEnvironment.errorRaised());
        if (roundEnvironment.errorRaised()) {
            return true;
        }
        print("roundEnvironment.processingOver(): " + roundEnvironment.processingOver());

        try {
//            File outFile = new File("app/src/main/java/" + packageName.replaceAll("\\.", "/"));
//            if (!outFile.exists()) {
//                outFile.mkdirs();
//            }
//            File srcFile = new File(outFile, className + ".java");
//            if (srcFile.exists()) {
//                srcFile.delete();
//            }
//            srcFile.createNewFile();
//            print("生成的类到底在哪： " + srcFile.getAbsolutePath());
//            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(srcFile));

            if (classGenerater == null) {

                String packageName = ClassGenerater.rootPackageName;
                String className = ClassGenerater.rootClassName;

                classGenerater = new ClassGenerater(roundEnvironment);
                jw = new JavaWriter(mFiler.createSourceFile(packageName + "." + className).openWriter());
                classGenerater.generate(jw);
                print("文件生成结束");
            }
        } catch (IOException e) {
            error("出错了：：\n" + e.getMessage());
            return true;
        }

        return false;
    }


    public static void error(String msg) {
        mMessager.printMessage(Diagnostic.Kind.ERROR, msg);
    }

    public static void print(String msg) {
        mMessager.printMessage(Diagnostic.Kind.NOTE, msg);
    }

}
