/*
 * Decompiled with CFR 0.152.
 */
package com.pichs.xsql.processor.util;

import com.pichs.xsql.annotation.SqlTable;
import com.pichs.xsql.processor.XSqlProcessor;
import com.pichs.xsql.processor.element.ClassElement;
import com.pichs.xsql.processor.element.FieldElement;
import com.pichs.xsql.processor.javawriter.JavaWriter;
import com.pichs.xsql.processor.kind.Modifys;
import com.pichs.xsql.processor.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class ClassGenerater {
    public static final String rootClassName = "XSqlProperties";
    public static final String rootPackageName = "com.pichs.xsql.property";
    private List<ClassElement> mClassElements = new ArrayList<ClassElement>();
    private String qualifiedName;

    public ClassGenerater(RoundEnvironment roundEnvironment) {
        Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(SqlTable.class);
        if (elements != null) {
            for (Element element : elements) {
                TypeElement typeElement;
                if (element.getKind() != ElementKind.CLASS || (typeElement = (TypeElement)element).getAnnotation(SqlTable.class) == null) continue;
                ClassElement classElement = new ClassElement(typeElement);
                this.mClassElements.add(classElement);
                XSqlProcessor.print("\u589e\u52a0\u4e86\u4e00\u4e2aClassElement: " + element.getSimpleName());
            }
        }
    }

    public void generate(JavaWriter jw) throws IOException {
        jw.emitPackage(rootPackageName);
        jw.beginType(rootClassName, "class", Modifys.getPublicFinal());
        jw.emitEmptyLine();
        XSqlProcessor.print("mClassElements: size :  " + this.mClassElements.size());
        for (ClassElement classElement : this.mClassElements) {
            jw.beginType(classElement.getClassName(), "class", Modifys.getPublicStaticFinal());
            jw.emitEmptyLine();
            List<FieldElement> fieldElements = classElement.getFieldElements();
            for (FieldElement fieldElement : fieldElements) {
                jw.emitField("String", fieldElement.getFieldName(), Modifys.getPublicStaticFinal(), Utils.formatString(fieldElement.getAnnFieldName()));
                jw.emitEmptyLine();
            }
            jw.endType();
            jw.emitEmptyLine();
        }
        jw.endType();
        jw.close();
    }
}

