/*
 * Decompiled with CFR 0.152.
 */
package com.pichs.xsql.processor;

import com.pichs.xsql.annotation.SqlTable;
import com.pichs.xsql.processor.javawriter.JavaWriter;
import com.pichs.xsql.processor.util.ClassGenerater;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class XSqlProcessor
extends AbstractProcessor {
    private Elements mElementsUtils;
    private Types mTypesUtils;
    private static Messager mMessager;
    private Filer mFiler;
    private ClassGenerater classGenerater;
    private JavaWriter jw;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.mFiler = processingEnvironment.getFiler();
        this.mElementsUtils = processingEnvironment.getElementUtils();
        this.mTypesUtils = processingEnvironment.getTypeUtils();
        mMessager = processingEnvironment.getMessager();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return super.getSupportedOptions();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add(SqlTable.class.getCanonicalName());
        return set;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        XSqlProcessor.print("roundEnvironment.errorRaised(): " + roundEnvironment.errorRaised());
        if (roundEnvironment.errorRaised()) {
            return true;
        }
        XSqlProcessor.print("roundEnvironment.processingOver(): " + roundEnvironment.processingOver());
        try {
            if (this.classGenerater == null) {
                String packageName = "com.pv.sql.property";
                String className = "SqlProperties";
                this.classGenerater = new ClassGenerater(roundEnvironment);
                this.jw = new JavaWriter(this.mFiler.createSourceFile(packageName + "." + className, new Element[0]).openWriter());
                this.classGenerater.generate(this.jw);
                XSqlProcessor.print("\u6587\u4ef6\u751f\u6210\u7ed3\u675f");
            }
        }
        catch (IOException e) {
            XSqlProcessor.error("\u51fa\u9519\u4e86\uff1a\uff1a\n" + e.getMessage());
            return true;
        }
        return false;
    }

    public static void error(String msg) {
        mMessager.printMessage(Diagnostic.Kind.ERROR, msg);
    }

    public static void print(String msg) {
        mMessager.printMessage(Diagnostic.Kind.NOTE, msg);
    }
}

